/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.api;

import com.authlete.common.api.AuthleteApi;
import com.authlete.common.conf.AuthleteConfiguration;
import com.authlete.common.conf.AuthletePropertiesConfiguration;
import java.lang.reflect.Constructor;

public class AuthleteApiFactory {
    private static final String IMPL_JAX_RS = "com.authlete.jaxrs.api.AuthleteApiImpl";
    private static final String IMPL_HTTP_URL_CONNECTION = "com.authlete.common.api.AuthleteApiImpl";
    private static final String[] sKnownImpls = new String[]{"com.authlete.jaxrs.api.AuthleteApiImpl", "com.authlete.common.api.AuthleteApiImpl"};
    private static AuthleteApi sDefaultApi;

    private AuthleteApiFactory() {
    }

    public static AuthleteApi create(AuthleteConfiguration configuration) {
        for (String className : sKnownImpls) {
            try {
                return AuthleteApiFactory.create(configuration, className);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static AuthleteApi create(AuthleteConfiguration configuration, String className) {
        AuthleteApi api;
        Constructor<?> constructor;
        Class<?> clazz;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null.");
        }
        if (className == null) {
            throw new IllegalArgumentException("className is null.");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(className + " is not found.", e);
        }
        if (!AuthleteApi.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(className + " does not implement AuthleteApi interface.");
        }
        try {
            constructor = clazz.getConstructor(AuthleteConfiguration.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(className + " does not have a constructor which takes one AuthleteConfiguration parameter.", e);
        }
        try {
            api = (AuthleteApi)constructor.newInstance(configuration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create an instance of " + className + ".", e);
        }
        return api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthleteApi getDefaultApi() {
        if (sDefaultApi != null) {
            return sDefaultApi;
        }
        Class<AuthleteApiFactory> clazz = AuthleteApiFactory.class;
        synchronized (AuthleteApiFactory.class) {
            if (sDefaultApi != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sDefaultApi;
            }
            AuthletePropertiesConfiguration ac = new AuthletePropertiesConfiguration();
            sDefaultApi = AuthleteApiFactory.create(ac);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultApi;
        }
    }
}

