/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.conf;

import com.authlete.common.conf.AuthleteConfiguration;
import com.authlete.common.util.PropertiesLoader;
import com.authlete.common.util.TypedProperties;
import com.neovisionaries.security.AESCipher;
import java.util.logging.Logger;

public class AuthletePropertiesConfiguration
implements AuthleteConfiguration {
    public static final String DEFAULT_KEY = "a281ac2de1195e8c91ea383d38d05d1c";
    public static final String DEFAULT_IV = "b6f5d0f0dd7146b0e3915ebd2dd078f3";
    public static final String DEFAULT_FILE = "authlete.properties";
    public static final String SYSTEM_PROPERTY_AUTHLETE_CONFIGURATION_FILE = "authlete.configuration.file";
    private static final String PROPERTY_KEY_BASE_URL = "base_url";
    private static final String PROPERTY_KEY_SERVICE_OWNER_API_KEY = "service_owner.api_key";
    private static final String PROPERTY_KEY_SERVICE_OWNER_API_SECRET_ENCRYPTED = "service_owner.api_secret.encrypted";
    private static final String PROPERTY_KEY_SERVICE_OWNER_API_SECRET = "service_owner.api_secret";
    private static final String PROPERTY_KEY_SERVICE_API_KEY = "service.api_key";
    private static final String PROPERTY_KEY_SERVICE_API_SECRET_ENCRYPTED = "service.api_secret.encrypted";
    private static final String PROPERTY_KEY_SERVICE_API_SECRET = "service.api_secret";
    private static final String BASE_URL_DEFAULT = "https://api.authlete.com";
    private String mBaseUrl;
    private String mServiceOwnerApiKey;
    private String mServiceOwnerApiSecret;
    private String mServiceApiKey;
    private String mServiceApiSecret;

    public AuthletePropertiesConfiguration(String key, String iv) {
        this(AuthletePropertiesConfiguration.getFile(), key, iv);
    }

    public AuthletePropertiesConfiguration(byte[] key, byte[] iv) {
        this(AuthletePropertiesConfiguration.getFile(), key, iv);
    }

    public AuthletePropertiesConfiguration(String file, String key, String iv) {
        this(file, AuthletePropertiesConfiguration.convertHexStringToBytes("key", key), AuthletePropertiesConfiguration.convertHexStringToBytes("iv", iv));
    }

    public AuthletePropertiesConfiguration(String file) {
        this(file, DEFAULT_KEY, DEFAULT_IV);
    }

    public AuthletePropertiesConfiguration() {
        this(AuthletePropertiesConfiguration.getFile(), DEFAULT_KEY, DEFAULT_IV);
    }

    public AuthletePropertiesConfiguration(String file, byte[] key, byte[] iv) {
        TypedProperties props = PropertiesLoader.load(file);
        if (props == null) {
            String message = String.format("Failed to load '%s'.", file);
            Logger.getLogger(AuthletePropertiesConfiguration.class.getName()).severe(message);
            return;
        }
        this.mBaseUrl = props.getString(PROPERTY_KEY_BASE_URL, BASE_URL_DEFAULT);
        this.mServiceOwnerApiKey = props.getString(PROPERTY_KEY_SERVICE_OWNER_API_KEY);
        String encryptedServiceOwnerApiSecret = props.getString(PROPERTY_KEY_SERVICE_OWNER_API_SECRET_ENCRYPTED);
        this.mServiceOwnerApiSecret = encryptedServiceOwnerApiSecret != null ? AuthletePropertiesConfiguration.createCipher(key, iv).decrypt(encryptedServiceOwnerApiSecret) : props.getString(PROPERTY_KEY_SERVICE_OWNER_API_SECRET);
        this.mServiceApiKey = props.getString(PROPERTY_KEY_SERVICE_API_KEY);
        String encryptedServiceApiSecret = props.getString(PROPERTY_KEY_SERVICE_API_SECRET_ENCRYPTED);
        this.mServiceApiSecret = encryptedServiceApiSecret != null ? AuthletePropertiesConfiguration.createCipher(key, iv).decrypt(encryptedServiceApiSecret) : props.getString(PROPERTY_KEY_SERVICE_API_SECRET);
    }

    private static String getFile() {
        String file = System.getProperty(SYSTEM_PROPERTY_AUTHLETE_CONFIGURATION_FILE);
        if (file != null && file.length() != 0) {
            return file;
        }
        return DEFAULT_FILE;
    }

    private static AESCipher createCipher(byte[] key, byte[] iv) {
        AuthletePropertiesConfiguration.ensureNonNull("key", key);
        AuthletePropertiesConfiguration.ensureNonNull("iv", iv);
        return new AESCipher().setKey(key, iv);
    }

    private static byte[] convertHexStringToBytes(String name, String value) {
        AuthletePropertiesConfiguration.ensureNonNull(name, value);
        int len = value.length();
        byte[] bytes = new byte[(len + 1) / 2];
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            int n = AuthletePropertiesConfiguration.convertHexCharToInt(c);
            if (i % 2 == 0) {
                bytes[i / 2] = (byte)(n << 4 & 0xFF);
                continue;
            }
            int n2 = i / 2;
            bytes[n2] = (byte)(bytes[n2] | (byte)(n & 0xFF));
        }
        return bytes;
    }

    private static int convertHexCharToInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    private static void ensureNonNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
    }

    @Override
    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    @Override
    public String getServiceOwnerApiKey() {
        return this.mServiceOwnerApiKey;
    }

    @Override
    public String getServiceOwnerApiSecret() {
        return this.mServiceOwnerApiSecret;
    }

    @Override
    public String getServiceApiKey() {
        return this.mServiceApiKey;
    }

    @Override
    public String getServiceApiSecret() {
        return this.mServiceApiSecret;
    }
}

