/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.ApiResponse;
import com.authlete.common.dto.Property;

public class IntrospectionResponse
extends ApiResponse {
    private static final long serialVersionUID = 4L;
    private static final String SUMMARY_FORMAT = "action=%s, clientId=%d, subject=%s, existent=%s, usable=%s, sufficient=%s, refreshable=%s, expiresAt=%d, scopes=%s, properties=%s";
    private Action action;
    private long clientId;
    private String subject;
    private String[] scopes;
    private boolean existent;
    private boolean usable;
    private boolean sufficient;
    private boolean refreshable;
    private String responseContent;
    private long expiresAt;
    private Property[] properties;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public long getClientId() {
        return this.clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public boolean isExistent() {
        return this.existent;
    }

    public void setExistent(boolean existent) {
        this.existent = existent;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public boolean isSufficient() {
        return this.sufficient;
    }

    public void setSufficient(boolean sufficient) {
        this.sufficient = sufficient;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    public String summarize() {
        return String.format(SUMMARY_FORMAT, new Object[]{this.action, this.clientId, this.subject, this.existent, this.usable, this.sufficient, this.refreshable, this.expiresAt, this.buildScopes(), this.buildProperties()});
    }

    private String buildScopes() {
        if (this.scopes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String scope : this.scopes) {
            sb.append(scope);
            sb.append(' ');
        }
        if (0 < this.scopes.length) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private String buildProperties() {
        if (this.properties == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Property property : this.properties) {
            if (property == null) continue;
            sb.append(property.getKey());
            sb.append("=");
            sb.append(property.getValue());
            sb.append(",");
        }
        if (0 < sb.length()) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "[");
        sb.append("]");
        return sb.toString();
    }

    public static enum Action {
        INTERNAL_SERVER_ERROR,
        BAD_REQUEST,
        UNAUTHORIZED,
        FORBIDDEN,
        OK;

    }
}

