/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import java.util.EnumSet;

abstract class EnumHelper<TEnum extends Enum<TEnum>> {
    private final Class<TEnum> mClass;
    private final TEnum[] mValues;

    public EnumHelper(Class<TEnum> enumClass, TEnum[] enumValues) {
        this.mClass = enumClass;
        this.mValues = enumValues;
    }

    public int toBits(TEnum[] array) {
        if (array == null) {
            return 0;
        }
        int bits = 0;
        for (TEnum entry : array) {
            bits |= 1 << this.getValue(entry);
        }
        return bits;
    }

    public int toBits(EnumSet<TEnum> set) {
        if (set == null) {
            return 0;
        }
        int bits = 0;
        for (Enum entry : set) {
            bits |= 1 << this.getValue(entry);
        }
        return bits;
    }

    public TEnum[] toArray(int bits) {
        return this.toArray(this.toSet(bits));
    }

    public TEnum[] toArray(EnumSet<TEnum> set) {
        if (set == null) {
            return null;
        }
        return set.toArray(this.newArray(set.size()));
    }

    public EnumSet<TEnum> toSet(int bits) {
        EnumSet<TEnum> set = EnumSet.noneOf(this.mClass);
        for (TEnum entry : this.mValues) {
            if ((bits & 1 << this.getValue(entry)) == 0) continue;
            set.add(entry);
        }
        return set;
    }

    public EnumSet<TEnum> toSet(TEnum[] array) {
        if (array == null) {
            return null;
        }
        EnumSet<TEnum> set = EnumSet.noneOf(this.mClass);
        for (TEnum entry : array) {
            set.add(entry);
        }
        return set;
    }

    protected abstract short getValue(TEnum var1);

    protected abstract TEnum[] newArray(int var1);
}

