/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum JWEAlg {
    RSA1_5(1, "RSA1_5"),
    RSA_OAEP(2, "RSA-OAEP"),
    RSA_OAEP_256(3, "RSA-OEAP-256"),
    A128KW(4, "A128KW"),
    A192KW(5, "A192KW"),
    A256KW(6, "A256KW"),
    DIR(7, "dir"),
    ECDH_ES(8, "ECDH-ES"),
    ECDH_ES_A128KW(9, "ECDH-ES+A128KW"),
    ECDH_ES_A192KW(10, "ECDH-ES+A192KW"),
    ECDH_ES_A256KW(11, "ECDH-ES+A256KW"),
    A128GCMKW(12, "A128GCMKW"),
    A192GCMKW(13, "A192GCMKW"),
    A256GCMKW(14, "A256GCMKW"),
    PBES2_HS256_A128KW(15, "PBES2-HS256+A128KW"),
    PBES2_HS384_A192KW(16, "PBES2-HS384+A192KW"),
    PBES2_HS512_A256KW(17, "PBES2-HS512+A256KW");

    private static final JWEAlg[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private JWEAlg(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static JWEAlg getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static JWEAlg parse(String alg) {
        if (alg == null) {
            return null;
        }
        for (JWEAlg entry : sValues) {
            if (!entry.mString.equals(alg)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<JWEAlg> set) {
        return sHelper.toBits(set);
    }

    public static JWEAlg[] toArray(int bits) {
        return (JWEAlg[])sHelper.toArray(bits);
    }

    public static EnumSet<JWEAlg> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<JWEAlg> toSet(JWEAlg[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = JWEAlg.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<JWEAlg> {
        public Helper(JWEAlg[] values) {
            super(JWEAlg.class, (Enum[])values);
        }

        @Override
        protected short getValue(JWEAlg entry) {
            return entry.getValue();
        }

        protected JWEAlg[] newArray(int size) {
            return new JWEAlg[size];
        }
    }
}

