/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import com.authlete.common.types.HashAlg;
import java.util.EnumSet;

public enum JWSAlg {
    NONE(0, "none", null),
    HS256(1, "HS256", HashAlg.SHA_256),
    HS384(2, "HS384", HashAlg.SHA_384),
    HS512(3, "HS512", HashAlg.SHA_512),
    RS256(4, "RS256", HashAlg.SHA_256),
    RS384(5, "RS384", HashAlg.SHA_384),
    RS512(6, "RS512", HashAlg.SHA_512),
    ES256(7, "ES256", HashAlg.SHA_256),
    ES384(8, "ES384", HashAlg.SHA_384),
    ES512(9, "ES512", HashAlg.SHA_512),
    PS256(10, "PS256", HashAlg.SHA_256),
    PS384(11, "PS384", HashAlg.SHA_384),
    PS512(12, "PS512", HashAlg.SHA_512);

    private static final JWSAlg[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;
    private final HashAlg mHashAlg;

    private JWSAlg(short value, String string2, HashAlg hashAlg) {
        this.mValue = value;
        this.mString = string2;
        this.mHashAlg = hashAlg;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public HashAlg getHashAlg() {
        return this.mHashAlg;
    }

    public static JWSAlg getByValue(short value) {
        if (value < 0 || sValues.length <= value) {
            return null;
        }
        return sValues[value];
    }

    public static JWSAlg parse(String alg) {
        if (alg == null) {
            return null;
        }
        for (JWSAlg entry : sValues) {
            if (!entry.mString.equals(alg)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<JWSAlg> set) {
        return sHelper.toBits(set);
    }

    public static JWSAlg[] toArray(int bits) {
        return (JWSAlg[])sHelper.toArray(bits);
    }

    public static EnumSet<JWSAlg> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<JWSAlg> toSet(JWSAlg[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = JWSAlg.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<JWSAlg> {
        public Helper(JWSAlg[] values) {
            super(JWSAlg.class, (Enum[])values);
        }

        @Override
        protected short getValue(JWSAlg entry) {
            return entry.getValue();
        }

        protected JWSAlg[] newArray(int size) {
            return new JWSAlg[size];
        }
    }
}

