/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.authlete.common.util.TypedProperties;

public abstract class StringBasedTypedProperties
extends TypedProperties {
    protected StringBasedTypedProperties() {
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setBoolean(String key, boolean value) {
        if (key == null) {
            return;
        }
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setFloat(String key, float value) {
        if (key == null) {
            return;
        }
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setInt(String key, int value) {
        if (key == null) {
            return;
        }
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setLong(String key, long value) {
        if (key == null) {
            return;
        }
        this.setString(key, String.valueOf(value));
    }
}

