/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class Utils {
    private static final Gson GSON = new Gson();
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();

    private Utils() {
    }

    public static String join(String[] strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        boolean useDelimiter = delimiter != null && delimiter.length() != 0;
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
            if (useDelimiter) {
                // empty if block
            }
            sb.append(delimiter);
        }
        if (useDelimiter && sb.length() != 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static String toJson(Object object) {
        return Utils.toJson(object, false);
    }

    public static String toJson(Object object, boolean pretty) {
        if (object == null) {
            return null;
        }
        if (pretty) {
            return PRETTY_GSON.toJson(object);
        }
        return GSON.toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> klass) {
        return (T)GSON.fromJson(json, klass);
    }
}

