/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.Pair;
import com.authlete.common.dto.Scope;
import com.authlete.common.dto.SnsCredentials;
import com.authlete.common.types.ClaimType;
import com.authlete.common.types.ClientAuthMethod;
import com.authlete.common.types.DeliveryMode;
import com.authlete.common.types.Display;
import com.authlete.common.types.GrantType;
import com.authlete.common.types.JWSAlg;
import com.authlete.common.types.ResponseType;
import com.authlete.common.types.ServiceProfile;
import com.authlete.common.types.Sns;
import java.io.Serializable;
import java.net.URI;
import java.util.TreeSet;

public class Service
implements Serializable {
    private static final long serialVersionUID = 25L;
    private int number;
    private int serviceOwnerNumber;
    private String serviceName;
    private long apiKey;
    private String apiSecret;
    private URI issuer;
    private URI authorizationEndpoint;
    private URI tokenEndpoint;
    private URI revocationEndpoint;
    private ClientAuthMethod[] supportedRevocationAuthMethods;
    private URI userInfoEndpoint;
    private URI jwksUri;
    private String jwks;
    private URI registrationEndpoint;
    private URI registrationManagementEndpoint;
    private Scope[] supportedScopes;
    private ResponseType[] supportedResponseTypes;
    private GrantType[] supportedGrantTypes;
    private String[] supportedAcrs;
    private ClientAuthMethod[] supportedTokenAuthMethods;
    private Display[] supportedDisplays;
    private ClaimType[] supportedClaimTypes;
    private String[] supportedClaims;
    private URI serviceDocumentation;
    private String[] supportedClaimLocales;
    private String[] supportedUiLocales;
    private URI policyUri;
    private URI tosUri;
    private URI authenticationCallbackEndpoint;
    private String authenticationCallbackApiKey;
    private String authenticationCallbackApiSecret;
    private Sns[] supportedSnses;
    private SnsCredentials[] snsCredentials;
    private long createdAt;
    private long modifiedAt;
    private URI developerAuthenticationCallbackEndpoint;
    private String developerAuthenticationCallbackApiKey;
    private String developerAuthenticationCallbackApiSecret;
    private Sns[] supportedDeveloperSnses;
    private SnsCredentials[] developerSnsCredentials;
    private int clientsPerDeveloper;
    private boolean directAuthorizationEndpointEnabled;
    private boolean directTokenEndpointEnabled;
    private boolean directRevocationEndpointEnabled;
    private boolean directUserInfoEndpointEnabled;
    private boolean directJwksEndpointEnabled;
    private boolean directIntrospectionEndpointEnabled;
    private boolean singleAccessTokenPerSubject;
    private boolean pkceRequired;
    private boolean refreshTokenKept;
    private boolean errorDescriptionOmitted;
    private boolean errorUriOmitted;
    private boolean clientIdAliasEnabled;
    private ServiceProfile[] supportedServiceProfiles;
    private boolean tlsClientCertificateBoundAccessTokens;
    private URI introspectionEndpoint;
    private ClientAuthMethod[] supportedIntrospectionAuthMethods;
    private boolean mutualTlsValidatePkiCertChain;
    private String[] trustedRootCertificates;
    private boolean dynamicRegistrationSupported;
    private String description;
    private String accessTokenType;
    private JWSAlg accessTokenSignAlg;
    private long accessTokenDuration;
    private long refreshTokenDuration;
    private long idTokenDuration;
    private long authorizationResponseDuration;
    private Pair[] metadata;
    private String accessTokenSignatureKeyId;
    private String authorizationSignatureKeyId;
    private String idTokenSignatureKeyId;
    private String userInfoSignatureKeyId;
    private DeliveryMode[] supportedBackchannelTokenDeliveryModes;
    private URI backchannelAuthenticationEndpoint;
    private boolean backchannelUserCodeParameterSupported;
    private int backchannelAuthReqIdDuration;
    private int backchannelPollingInterval;
    private int allowableClockSkew;
    private URI deviceAuthorizationEndpoint;
    private URI deviceVerificationUri;
    private URI deviceVerificationUriComplete;
    private int deviceFlowCodeDuration;
    private int deviceFlowPollingInterval;

    public int getNumber() {
        return this.number;
    }

    public Service setNumber(int number) {
        this.number = number;
        return this;
    }

    public int getServiceOwnerNumber() {
        return this.serviceOwnerNumber;
    }

    public Service setServiceOwnerNumber(int serviceOwnerNumber) {
        this.serviceOwnerNumber = serviceOwnerNumber;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Service setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public long getApiKey() {
        return this.apiKey;
    }

    public Service setApiKey(long apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public Service setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public Service setIssuer(URI issuer) {
        this.issuer = issuer;
        return this;
    }

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public Service setAuthorizationEndpoint(URI endpoint) {
        this.authorizationEndpoint = endpoint;
        return this;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Service setTokenEndpoint(URI endpoint) {
        this.tokenEndpoint = endpoint;
        return this;
    }

    public URI getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public ClientAuthMethod[] getSupportedRevocationAuthMethods() {
        return this.supportedRevocationAuthMethods;
    }

    public Service setSupportedRevocationAuthMethods(ClientAuthMethod[] methods) {
        this.supportedRevocationAuthMethods = methods;
        return this;
    }

    public Service setRevocationEndpoint(URI endpoint) {
        this.revocationEndpoint = endpoint;
        return this;
    }

    public URI getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public Service setUserInfoEndpoint(URI endpoint) {
        this.userInfoEndpoint = endpoint;
        return this;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public Service setJwksUri(URI uri) {
        this.jwksUri = uri;
        return this;
    }

    public String getJwks() {
        return this.jwks;
    }

    public Service setJwks(String jwks) {
        this.jwks = jwks;
        return this;
    }

    public URI getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public Service setRegistrationEndpoint(URI endpoint) {
        this.registrationEndpoint = endpoint;
        return this;
    }

    public URI getRegistrationManagementEndpoint() {
        return this.registrationManagementEndpoint;
    }

    public Service setRegistrationManagementEndpoint(URI endpoint) {
        this.registrationManagementEndpoint = endpoint;
        return this;
    }

    public Scope[] getSupportedScopes() {
        return this.supportedScopes;
    }

    public Service setSupportedScopes(Scope[] supportedScopes) {
        this.supportedScopes = supportedScopes;
        return this;
    }

    public ResponseType[] getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public Service setSupportedResponseTypes(ResponseType[] responseTypes) {
        this.supportedResponseTypes = responseTypes;
        return this;
    }

    public GrantType[] getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public Service setSupportedGrantTypes(GrantType[] grantTypes) {
        this.supportedGrantTypes = grantTypes;
        return this;
    }

    public String[] getSupportedAcrs() {
        return this.supportedAcrs;
    }

    public Service setSupportedAcrs(String[] acrs) {
        this.supportedAcrs = acrs;
        return this;
    }

    public ClientAuthMethod[] getSupportedTokenAuthMethods() {
        return this.supportedTokenAuthMethods;
    }

    public Service setSupportedTokenAuthMethods(ClientAuthMethod[] methods) {
        this.supportedTokenAuthMethods = methods;
        return this;
    }

    public Display[] getSupportedDisplays() {
        return this.supportedDisplays;
    }

    public Service setSupportedDisplays(Display[] displays) {
        this.supportedDisplays = displays;
        return this;
    }

    public ClaimType[] getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public Service setSupportedClaimTypes(ClaimType[] claimTypes) {
        this.supportedClaimTypes = claimTypes;
        return this;
    }

    public String[] getSupportedClaims() {
        return this.supportedClaims;
    }

    public Service setSupportedClaims(String[] supportedClaims) {
        this.supportedClaims = supportedClaims;
        return this;
    }

    public URI getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public Service setServiceDocumentation(URI uri) {
        this.serviceDocumentation = uri;
        return this;
    }

    public String[] getSupportedClaimLocales() {
        return this.supportedClaimLocales;
    }

    public Service setSupportedClaimLocales(String[] supportedClaimLocales) {
        this.supportedClaimLocales = supportedClaimLocales;
        return this;
    }

    public String[] getSupportedUiLocales() {
        return this.supportedUiLocales;
    }

    public Service setSupportedUiLocales(String[] supportedUiLocales) {
        this.supportedUiLocales = supportedUiLocales;
        return this;
    }

    public URI getPolicyUri() {
        return this.policyUri;
    }

    public Service setPolicyUri(URI uri) {
        this.policyUri = uri;
        return this;
    }

    public URI getTosUri() {
        return this.tosUri;
    }

    public Service setTosUri(URI uri) {
        this.tosUri = uri;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Service setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public Service setAccessTokenType(String type) {
        this.accessTokenType = type;
        return this;
    }

    public JWSAlg getAccessTokenSignAlg() {
        return this.accessTokenSignAlg;
    }

    public Service setAccessTokenSignAlg(JWSAlg alg) {
        this.accessTokenSignAlg = alg;
        return this;
    }

    public long getAccessTokenDuration() {
        return this.accessTokenDuration;
    }

    public Service setAccessTokenDuration(long duration) {
        this.accessTokenDuration = duration;
        return this;
    }

    public long getRefreshTokenDuration() {
        return this.refreshTokenDuration;
    }

    public Service setRefreshTokenDuration(long duration) {
        this.refreshTokenDuration = duration;
        return this;
    }

    public long getIdTokenDuration() {
        return this.idTokenDuration;
    }

    public Service setIdTokenDuration(long duration) {
        this.idTokenDuration = duration;
        return this;
    }

    public long getAuthorizationResponseDuration() {
        return this.authorizationResponseDuration;
    }

    public Service setAuthorizationResponseDuration(long duration) {
        this.authorizationResponseDuration = duration;
        return this;
    }

    public URI getAuthenticationCallbackEndpoint() {
        return this.authenticationCallbackEndpoint;
    }

    public Service setAuthenticationCallbackEndpoint(URI endpoint) {
        this.authenticationCallbackEndpoint = endpoint;
        return this;
    }

    public String getAuthenticationCallbackApiKey() {
        return this.authenticationCallbackApiKey;
    }

    public Service setAuthenticationCallbackApiKey(String apiKey) {
        this.authenticationCallbackApiKey = apiKey;
        return this;
    }

    public String getAuthenticationCallbackApiSecret() {
        return this.authenticationCallbackApiSecret;
    }

    public Service setAuthenticationCallbackApiSecret(String apiSecret) {
        this.authenticationCallbackApiSecret = apiSecret;
        return this;
    }

    public Sns[] getSupportedSnses() {
        return this.supportedSnses;
    }

    public Service setSupportedSnses(Sns[] supportedSnses) {
        this.supportedSnses = supportedSnses;
        return this;
    }

    public SnsCredentials[] getSnsCredentials() {
        return this.snsCredentials;
    }

    public Service setSnsCredentials(SnsCredentials[] snsCredentials) {
        this.snsCredentials = snsCredentials;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Service setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public Service setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public Pair[] getMetadata() {
        return this.metadata;
    }

    public Service setMetadata(Pair[] metadata) {
        this.metadata = metadata;
        return this;
    }

    public URI getDeveloperAuthenticationCallbackEndpoint() {
        return this.developerAuthenticationCallbackEndpoint;
    }

    public Service setDeveloperAuthenticationCallbackEndpoint(URI endpoint) {
        this.developerAuthenticationCallbackEndpoint = endpoint;
        return this;
    }

    public String getDeveloperAuthenticationCallbackApiKey() {
        return this.developerAuthenticationCallbackApiKey;
    }

    public Service setDeveloperAuthenticationCallbackApiKey(String apiKey) {
        this.developerAuthenticationCallbackApiKey = apiKey;
        return this;
    }

    public String getDeveloperAuthenticationCallbackApiSecret() {
        return this.developerAuthenticationCallbackApiSecret;
    }

    public Service setDeveloperAuthenticationCallbackApiSecret(String apiSecret) {
        this.developerAuthenticationCallbackApiSecret = apiSecret;
        return this;
    }

    public Sns[] getSupportedDeveloperSnses() {
        return this.supportedDeveloperSnses;
    }

    public Service setSupportedDeveloperSnses(Sns[] supportedSnses) {
        this.supportedDeveloperSnses = supportedSnses;
        return this;
    }

    public SnsCredentials[] getDeveloperSnsCredentials() {
        return this.developerSnsCredentials;
    }

    public Service setDeveloperSnsCredentials(SnsCredentials[] snsCredentials) {
        this.developerSnsCredentials = snsCredentials;
        return this;
    }

    public int getClientsPerDeveloper() {
        return this.clientsPerDeveloper;
    }

    public Service setClientsPerDeveloper(int count) {
        this.clientsPerDeveloper = count;
        return this;
    }

    public boolean isDirectAuthorizationEndpointEnabled() {
        return this.directAuthorizationEndpointEnabled;
    }

    public Service setDirectAuthorizationEndpointEnabled(boolean enabled) {
        this.directAuthorizationEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectTokenEndpointEnabled() {
        return this.directTokenEndpointEnabled;
    }

    public Service setDirectTokenEndpointEnabled(boolean enabled) {
        this.directTokenEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectRevocationEndpointEnabled() {
        return this.directRevocationEndpointEnabled;
    }

    public Service setDirectRevocationEndpointEnabled(boolean enabled) {
        this.directRevocationEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectUserInfoEndpointEnabled() {
        return this.directUserInfoEndpointEnabled;
    }

    public Service setDirectUserInfoEndpointEnabled(boolean enabled) {
        this.directUserInfoEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectJwksEndpointEnabled() {
        return this.directJwksEndpointEnabled;
    }

    public Service setDirectJwksEndpointEnabled(boolean enabled) {
        this.directJwksEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectIntrospectionEndpointEnabled() {
        return this.directIntrospectionEndpointEnabled;
    }

    public Service setDirectIntrospectionEndpointEnabled(boolean enabled) {
        this.directIntrospectionEndpointEnabled = enabled;
        return this;
    }

    public boolean isSingleAccessTokenPerSubject() {
        return this.singleAccessTokenPerSubject;
    }

    public Service setSingleAccessTokenPerSubject(boolean single) {
        this.singleAccessTokenPerSubject = single;
        return this;
    }

    public boolean isPkceRequired() {
        return this.pkceRequired;
    }

    public Service setPkceRequired(boolean required) {
        this.pkceRequired = required;
        return this;
    }

    public boolean isRefreshTokenKept() {
        return this.refreshTokenKept;
    }

    public Service setRefreshTokenKept(boolean kept) {
        this.refreshTokenKept = kept;
        return this;
    }

    public boolean isErrorDescriptionOmitted() {
        return this.errorDescriptionOmitted;
    }

    public Service setErrorDescriptionOmitted(boolean omitted) {
        this.errorDescriptionOmitted = omitted;
        return this;
    }

    public boolean isErrorUriOmitted() {
        return this.errorUriOmitted;
    }

    public Service setErrorUriOmitted(boolean omitted) {
        this.errorUriOmitted = omitted;
        return this;
    }

    public boolean isClientIdAliasEnabled() {
        return this.clientIdAliasEnabled;
    }

    public Service setClientIdAliasEnabled(boolean enabled) {
        this.clientIdAliasEnabled = enabled;
        return this;
    }

    public String getAccessTokenSignatureKeyId() {
        return this.accessTokenSignatureKeyId;
    }

    public Service setAccessTokenSignatureKeyId(String keyId) {
        this.accessTokenSignatureKeyId = keyId;
        return this;
    }

    public String getAuthorizationSignatureKeyId() {
        return this.authorizationSignatureKeyId;
    }

    public Service setAuthorizationSignatureKeyId(String keyId) {
        this.authorizationSignatureKeyId = keyId;
        return this;
    }

    public String getIdTokenSignatureKeyId() {
        return this.idTokenSignatureKeyId;
    }

    public Service setIdTokenSignatureKeyId(String keyId) {
        this.idTokenSignatureKeyId = keyId;
        return this;
    }

    public String getUserInfoSignatureKeyId() {
        return this.userInfoSignatureKeyId;
    }

    public Service setUserInfoSignatureKeyId(String keyId) {
        this.userInfoSignatureKeyId = keyId;
        return this;
    }

    public ServiceProfile[] getSupportedServiceProfiles() {
        return this.supportedServiceProfiles;
    }

    public Service setSupportedServiceProfiles(ServiceProfile[] profiles) {
        this.supportedServiceProfiles = profiles;
        return this;
    }

    public Service setSupportedServiceProfiles(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            this.supportedServiceProfiles = null;
            return this;
        }
        TreeSet<ServiceProfile> set = new TreeSet<ServiceProfile>();
        for (ServiceProfile profile : profiles) {
            if (profile == null) continue;
            set.add(profile);
        }
        int size = set.size();
        if (size == 0) {
            this.supportedServiceProfiles = null;
            return this;
        }
        ServiceProfile[] array = new ServiceProfile[size];
        this.supportedServiceProfiles = set.toArray(array);
        return this;
    }

    public boolean supports(ServiceProfile profile) {
        if (profile == null) {
            return false;
        }
        if (this.supportedServiceProfiles == null) {
            return false;
        }
        for (ServiceProfile supportedProfile : this.supportedServiceProfiles) {
            if (supportedProfile != profile) continue;
            return true;
        }
        return false;
    }

    public boolean supportsAll(ServiceProfile ... profiles) {
        if (profiles == null) {
            return true;
        }
        for (ServiceProfile profile : profiles) {
            if (this.supports(profile)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsAll(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            return true;
        }
        for (ServiceProfile profile : profiles) {
            if (this.supports(profile)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsAny(ServiceProfile ... profiles) {
        if (profiles == null) {
            return false;
        }
        for (ServiceProfile profile : profiles) {
            if (!this.supports(profile)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsAny(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            return false;
        }
        for (ServiceProfile profile : profiles) {
            if (!this.supports(profile)) continue;
            return true;
        }
        return false;
    }

    public boolean isTlsClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public Service setTlsClientCertificateBoundAccessTokens(boolean enabled) {
        this.tlsClientCertificateBoundAccessTokens = enabled;
        return this;
    }

    public URI getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public Service setIntrospectionEndpoint(URI endpoint) {
        this.introspectionEndpoint = endpoint;
        return this;
    }

    public ClientAuthMethod[] getSupportedIntrospectionAuthMethods() {
        return this.supportedIntrospectionAuthMethods;
    }

    public Service setSupportedIntrospectionAuthMethods(ClientAuthMethod[] methods) {
        this.supportedIntrospectionAuthMethods = methods;
        return this;
    }

    public boolean isMutualTlsValidatePkiCertChain() {
        return this.mutualTlsValidatePkiCertChain;
    }

    public Service setMutualTlsValidatePkiCertChain(boolean mutualTlsValidatePkiCertChain) {
        this.mutualTlsValidatePkiCertChain = mutualTlsValidatePkiCertChain;
        return this;
    }

    public String[] getTrustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    public Service setTrustedRootCertificates(String[] trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    public DeliveryMode[] getSupportedBackchannelTokenDeliveryModes() {
        return this.supportedBackchannelTokenDeliveryModes;
    }

    public Service setSupportedBackchannelTokenDeliveryModes(DeliveryMode[] modes) {
        this.supportedBackchannelTokenDeliveryModes = modes;
        return this;
    }

    public URI getBackchannelAuthenticationEndpoint() {
        return this.backchannelAuthenticationEndpoint;
    }

    public Service setBackchannelAuthenticationEndpoint(URI endpoint) {
        this.backchannelAuthenticationEndpoint = endpoint;
        return this;
    }

    public boolean isBackchannelUserCodeParameterSupported() {
        return this.backchannelUserCodeParameterSupported;
    }

    public Service setBackchannelUserCodeParameterSupported(boolean supported) {
        this.backchannelUserCodeParameterSupported = supported;
        return this;
    }

    public int getBackchannelAuthReqIdDuration() {
        return this.backchannelAuthReqIdDuration;
    }

    public Service setBackchannelAuthReqIdDuration(int duration) {
        this.backchannelAuthReqIdDuration = duration;
        return this;
    }

    public int getBackchannelPollingInterval() {
        return this.backchannelPollingInterval;
    }

    public Service setBackchannelPollingInterval(int interval) {
        this.backchannelPollingInterval = interval;
        return this;
    }

    public int getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public Service setAllowableClockSkew(int seconds) {
        this.allowableClockSkew = seconds;
        return this;
    }

    public boolean isDynamicRegistrationSupported() {
        return this.dynamicRegistrationSupported;
    }

    public Service setDynamicRegistrationSupported(boolean enabled) {
        this.dynamicRegistrationSupported = enabled;
        return this;
    }

    public URI getDeviceAuthorizationEndpoint() {
        return this.deviceAuthorizationEndpoint;
    }

    public Service setDeviceAuthorizationEndpoint(URI endpoint) {
        this.deviceAuthorizationEndpoint = endpoint;
        return this;
    }

    public URI getDeviceVerificationUri() {
        return this.deviceVerificationUri;
    }

    public Service setDeviceVerificationUri(URI uri) {
        this.deviceVerificationUri = uri;
        return this;
    }

    public URI getDeviceVerificationUriComplete() {
        return this.deviceVerificationUriComplete;
    }

    public Service setDeviceVerificationUriComplete(URI uri) {
        this.deviceVerificationUriComplete = uri;
        return this;
    }

    public int getDeviceFlowCodeDuration() {
        return this.deviceFlowCodeDuration;
    }

    public Service setDeviceFlowCodeDuration(int duration) {
        this.deviceFlowCodeDuration = duration;
        return this;
    }

    public int getDeviceFlowPollingInterval() {
        return this.deviceFlowPollingInterval;
    }

    public Service setDeviceFlowPollingInterval(int interval) {
        this.deviceFlowPollingInterval = interval;
        return this;
    }
}

