/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.api;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

class ConnectionContext {
    private final HttpURLConnection mCon;
    private InputStream mIn;
    private OutputStream mOut;
    private InputStream mErr;

    public ConnectionContext(HttpURLConnection connection) {
        this.mCon = connection;
    }

    public HttpURLConnection connection() {
        return this.mCon;
    }

    public int contentLength() {
        return this.mCon.getContentLength();
    }

    public void property(String key, String value) {
        this.mCon.setRequestProperty(key, value);
    }

    public void doOutput(boolean dooutput) {
        this.mCon.setDoOutput(dooutput);
    }

    public InputStream inputStream() throws IOException {
        if (this.mIn == null) {
            this.mIn = this.mCon.getInputStream();
        }
        return this.mIn;
    }

    public OutputStream outputStream() throws IOException {
        if (this.mOut == null) {
            this.mOut = this.mCon.getOutputStream();
        }
        return this.mOut;
    }

    public InputStream errorStream() {
        if (this.mErr == null) {
            this.mErr = this.mCon.getErrorStream();
        }
        return this.mErr;
    }

    public void close() {
        ConnectionContext.closeQuietly(this.mIn);
        ConnectionContext.closeQuietly(this.mOut);
        ConnectionContext.closeQuietly(this.mErr);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

