/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.LeafConstraint;
import java.util.Map;

public class IssuerConstraint
extends BaseConstraint {
    private LeafConstraint name;
    private LeafConstraint country;

    public LeafConstraint getName() {
        return this.name;
    }

    public void setName(LeafConstraint constraint) {
        this.name = constraint;
    }

    public LeafConstraint getCountry() {
        return this.country;
    }

    public void setCountry(LeafConstraint constraint) {
        this.country = constraint;
    }

    public static IssuerConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        IssuerConstraint instance = new IssuerConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            IssuerConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(IssuerConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        instance.name = LeafConstraint.extract(map, "name");
        instance.country = LeafConstraint.extract(map, "country");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        IssuerConstraint.addIfAvailable(map, "name", this.name);
        IssuerConstraint.addIfAvailable(map, "country", this.country);
        return map;
    }
}

