/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.EvidenceConstraint;
import com.authlete.common.assurance.constraint.LeafConstraint;
import java.util.Map;

public class QESConstraint
extends EvidenceConstraint {
    private LeafConstraint issuer;
    private LeafConstraint serialNumber;
    private LeafConstraint createdAt;

    public LeafConstraint getIssuer() {
        return this.issuer;
    }

    public void setIssuer(LeafConstraint constraint) {
        this.issuer = constraint;
    }

    public LeafConstraint getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(LeafConstraint constraint) {
        this.serialNumber = constraint;
    }

    public LeafConstraint getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LeafConstraint constraint) {
        this.createdAt = constraint;
    }

    public static QESConstraint extract(Map<?, ?> map) throws ConstraintException {
        QESConstraint instance = new QESConstraint();
        instance.setExists(true);
        QESConstraint.fill(instance, map);
        return instance;
    }

    private static void fill(QESConstraint instance, Map<?, ?> map) {
        EvidenceConstraint.fill(instance, map);
        instance.issuer = LeafConstraint.extract(map, "issuer");
        instance.serialNumber = LeafConstraint.extract(map, "serial_number");
        instance.createdAt = LeafConstraint.extract(map, "created_at");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        QESConstraint.addIfAvailable(map, "issuer", this.issuer);
        QESConstraint.addIfAvailable(map, "serial_number", this.serialNumber);
        QESConstraint.addIfAvailable(map, "created_at", this.createdAt);
        return map;
    }
}

