/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.ClientExtension;
import com.authlete.common.dto.Pair;
import com.authlete.common.dto.TaggedValue;
import com.authlete.common.types.ApplicationType;
import com.authlete.common.types.ClientAuthMethod;
import com.authlete.common.types.ClientType;
import com.authlete.common.types.DeliveryMode;
import com.authlete.common.types.GrantType;
import com.authlete.common.types.JWEAlg;
import com.authlete.common.types.JWEEnc;
import com.authlete.common.types.JWSAlg;
import com.authlete.common.types.ResponseType;
import com.authlete.common.types.SubjectType;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;

public class Client
implements Serializable {
    private static final long serialVersionUID = 24L;
    private int number;
    private int serviceNumber;
    private String developer;
    private long clientId;
    private String clientIdAlias;
    private boolean clientIdAliasEnabled;
    private String clientSecret;
    private ClientType clientType;
    private String[] redirectUris;
    private ResponseType[] responseTypes;
    private GrantType[] grantTypes;
    private ApplicationType applicationType;
    private String[] contacts;
    private String clientName;
    private TaggedValue[] clientNames;
    private URI logoUri;
    private TaggedValue[] logoUris;
    private URI clientUri;
    private TaggedValue[] clientUris;
    private URI policyUri;
    private TaggedValue[] policyUris;
    private URI tosUri;
    private TaggedValue[] tosUris;
    private URI jwksUri;
    private String jwks;
    private String derivedSectorIdentifier;
    private URI sectorIdentifierUri;
    private SubjectType subjectType;
    private JWSAlg idTokenSignAlg;
    private JWEAlg idTokenEncryptionAlg;
    private JWEEnc idTokenEncryptionEnc;
    private JWSAlg userInfoSignAlg;
    private JWEAlg userInfoEncryptionAlg;
    private JWEEnc userInfoEncryptionEnc;
    private JWSAlg requestSignAlg;
    private JWEAlg requestEncryptionAlg;
    private JWEEnc requestEncryptionEnc;
    private ClientAuthMethod tokenAuthMethod;
    private JWSAlg tokenAuthSignAlg;
    private int defaultMaxAge;
    private String[] defaultAcrs;
    private boolean authTimeRequired;
    private URI loginUri;
    private String[] requestUris;
    private String description;
    private TaggedValue[] descriptions;
    private long createdAt;
    private long modifiedAt;
    private ClientExtension extension;
    private String tlsClientAuthSubjectDn;
    private String tlsClientAuthSanDns;
    private URI tlsClientAuthSanUri;
    private String tlsClientAuthSanIp;
    private String tlsClientAuthSanEmail;
    private boolean tlsClientCertificateBoundAccessTokens;
    private String selfSignedCertificateKeyId;
    private String softwareId;
    private String softwareVersion;
    private JWSAlg authorizationSignAlg;
    private JWEAlg authorizationEncryptionAlg;
    private JWEEnc authorizationEncryptionEnc;
    private DeliveryMode bcDeliveryMode;
    private URI bcNotificationEndpoint;
    private JWSAlg bcRequestSignAlg;
    private boolean bcUserCodeRequired;
    private boolean dynamicallyRegistered;
    private String registrationAccessTokenHash;
    private String[] authorizationDetailsTypes;
    private boolean parRequired;
    private boolean requestObjectRequired;
    private Pair[] attributes;
    private String customMetadata;
    private boolean frontChannelRequestObjectEncryptionRequired;
    private boolean requestObjectEncryptionAlgMatchRequired;
    private boolean requestObjectEncryptionEncMatchRequired;
    private String digestAlgorithm;

    public int getNumber() {
        return this.number;
    }

    public Client setNumber(int number) {
        this.number = number;
        return this;
    }

    public int getServiceNumber() {
        return this.serviceNumber;
    }

    public Client setServiceNumber(int number) {
        this.serviceNumber = number;
        return this;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public Client setDeveloper(String developer) {
        this.developer = developer;
        return this;
    }

    public long getClientId() {
        return this.clientId;
    }

    public Client setClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientIdAlias() {
        return this.clientIdAlias;
    }

    public Client setClientIdAlias(String alias) {
        this.clientIdAlias = alias;
        return this;
    }

    public boolean isClientIdAliasEnabled() {
        return this.clientIdAliasEnabled;
    }

    public Client setClientIdAliasEnabled(boolean enabled) {
        this.clientIdAliasEnabled = enabled;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Client setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public Client setClientType(ClientType clientType) {
        this.clientType = clientType;
        return this;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public Client setRedirectUris(String[] uris) {
        this.redirectUris = uris;
        return this;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public Client setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public GrantType[] getGrantTypes() {
        return this.grantTypes;
    }

    public Client setGrantTypes(GrantType[] grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public Client setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public Client setContacts(String[] contacts) {
        this.contacts = contacts;
        return this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public Client setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public TaggedValue[] getClientNames() {
        return this.clientNames;
    }

    public Client setClientNames(TaggedValue[] clientNames) {
        this.clientNames = clientNames;
        return this;
    }

    public URI getLogoUri() {
        return this.logoUri;
    }

    public Client setLogoUri(URI uri) {
        this.logoUri = uri;
        return this;
    }

    public TaggedValue[] getLogoUris() {
        return this.logoUris;
    }

    public Client setLogoUris(TaggedValue[] uris) {
        this.logoUris = uris;
        return this;
    }

    public URI getClientUri() {
        return this.clientUri;
    }

    public Client setClientUri(URI uri) {
        this.clientUri = uri;
        return this;
    }

    public TaggedValue[] getClientUris() {
        return this.clientUris;
    }

    public Client setClientUris(TaggedValue[] uris) {
        this.clientUris = uris;
        return this;
    }

    public URI getPolicyUri() {
        return this.policyUri;
    }

    public Client setPolicyUri(URI uri) {
        this.policyUri = uri;
        return this;
    }

    public TaggedValue[] getPolicyUris() {
        return this.policyUris;
    }

    public Client setPolicyUris(TaggedValue[] uris) {
        this.policyUris = uris;
        return this;
    }

    public URI getTosUri() {
        return this.tosUri;
    }

    public Client setTosUri(URI uri) {
        this.tosUri = uri;
        return this;
    }

    public TaggedValue[] getTosUris() {
        return this.tosUris;
    }

    public Client setTosUris(TaggedValue[] uris) {
        this.tosUris = uris;
        return this;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public Client setJwksUri(URI uri) {
        this.jwksUri = uri;
        return this;
    }

    public String getJwks() {
        return this.jwks;
    }

    public Client setJwks(String jwks) {
        this.jwks = jwks;
        return this;
    }

    @Deprecated
    public URI getSectorIdentifier() {
        return this.getSectorIdentifierUri();
    }

    @Deprecated
    public Client setSectorIdentifier(URI sectorIdentifier) {
        return this.setSectorIdentifierUri(sectorIdentifier);
    }

    public URI getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public Client setSectorIdentifierUri(URI uri) {
        this.sectorIdentifierUri = uri;
        return this;
    }

    public String getDerivedSectorIdentifier() {
        return this.derivedSectorIdentifier;
    }

    public Client setDerivedSectorIdentifier(String derivedSectorIdentifier) {
        this.derivedSectorIdentifier = derivedSectorIdentifier;
        return this;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public Client setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    public JWSAlg getIdTokenSignAlg() {
        return this.idTokenSignAlg;
    }

    public Client setIdTokenSignAlg(JWSAlg alg) {
        this.idTokenSignAlg = alg;
        return this;
    }

    public JWEAlg getIdTokenEncryptionAlg() {
        return this.idTokenEncryptionAlg;
    }

    public Client setIdTokenEncryptionAlg(JWEAlg alg) {
        this.idTokenEncryptionAlg = alg;
        return this;
    }

    public JWEEnc getIdTokenEncryptionEnc() {
        return this.idTokenEncryptionEnc;
    }

    public Client setIdTokenEncryptionEnc(JWEEnc enc) {
        this.idTokenEncryptionEnc = enc;
        return this;
    }

    public JWSAlg getUserInfoSignAlg() {
        return this.userInfoSignAlg;
    }

    public Client setUserInfoSignAlg(JWSAlg alg) {
        this.userInfoSignAlg = alg;
        return this;
    }

    public JWEAlg getUserInfoEncryptionAlg() {
        return this.userInfoEncryptionAlg;
    }

    public Client setUserInfoEncryptionAlg(JWEAlg alg) {
        this.userInfoEncryptionAlg = alg;
        return this;
    }

    public JWEEnc getUserInfoEncryptionEnc() {
        return this.userInfoEncryptionEnc;
    }

    public Client setUserInfoEncryptionEnc(JWEEnc enc) {
        this.userInfoEncryptionEnc = enc;
        return this;
    }

    public JWSAlg getRequestSignAlg() {
        return this.requestSignAlg;
    }

    public Client setRequestSignAlg(JWSAlg alg) {
        this.requestSignAlg = alg;
        return this;
    }

    public JWEAlg getRequestEncryptionAlg() {
        return this.requestEncryptionAlg;
    }

    public Client setRequestEncryptionAlg(JWEAlg alg) {
        this.requestEncryptionAlg = alg;
        return this;
    }

    public JWEEnc getRequestEncryptionEnc() {
        return this.requestEncryptionEnc;
    }

    public Client setRequestEncryptionEnc(JWEEnc enc) {
        this.requestEncryptionEnc = enc;
        return this;
    }

    public ClientAuthMethod getTokenAuthMethod() {
        return this.tokenAuthMethod;
    }

    public Client setTokenAuthMethod(ClientAuthMethod method) {
        this.tokenAuthMethod = method;
        return this;
    }

    public JWSAlg getTokenAuthSignAlg() {
        return this.tokenAuthSignAlg;
    }

    public Client setTokenAuthSignAlg(JWSAlg alg) {
        this.tokenAuthSignAlg = alg;
        return this;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public Client setDefaultMaxAge(int defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
        return this;
    }

    public boolean isAuthTimeRequired() {
        return this.authTimeRequired;
    }

    public Client setAuthTimeRequired(boolean required) {
        this.authTimeRequired = required;
        return this;
    }

    public String[] getDefaultAcrs() {
        return this.defaultAcrs;
    }

    public Client setDefaultAcrs(String[] defaultAcrs) {
        this.defaultAcrs = defaultAcrs;
        return this;
    }

    public URI getLoginUri() {
        return this.loginUri;
    }

    public Client setLoginUri(URI uri) {
        this.loginUri = uri;
        return this;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public Client setRequestUris(String[] uris) {
        this.requestUris = uris;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Client setDescription(String description) {
        this.description = description;
        return this;
    }

    public TaggedValue[] getDescriptions() {
        return this.descriptions;
    }

    public Client setDescriptions(TaggedValue[] descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Client setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public Client setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public ClientExtension getExtension() {
        return this.extension;
    }

    public Client setExtension(ClientExtension extension) {
        this.extension = extension;
        return this;
    }

    public String getTlsClientAuthSubjectDn() {
        return this.tlsClientAuthSubjectDn;
    }

    public Client setTlsClientAuthSubjectDn(String name) {
        this.tlsClientAuthSubjectDn = name;
        return this;
    }

    public String getTlsClientAuthSanDns() {
        return this.tlsClientAuthSanDns;
    }

    public Client setTlsClientAuthSanDns(String tlsClientAuthSanDns) {
        this.tlsClientAuthSanDns = tlsClientAuthSanDns;
        return this;
    }

    public URI getTlsClientAuthSanUri() {
        return this.tlsClientAuthSanUri;
    }

    public Client setTlsClientAuthSanUri(URI tlsClientAuthSanUri) {
        this.tlsClientAuthSanUri = tlsClientAuthSanUri;
        return this;
    }

    public String getTlsClientAuthSanIp() {
        return this.tlsClientAuthSanIp;
    }

    public Client setTlsClientAuthSanIp(String tlsClientAuthSanIp) {
        this.tlsClientAuthSanIp = tlsClientAuthSanIp;
        return this;
    }

    public String getTlsClientAuthSanEmail() {
        return this.tlsClientAuthSanEmail;
    }

    public Client setTlsClientAuthSanEmail(String tlsClientAuthSanEmail) {
        this.tlsClientAuthSanEmail = tlsClientAuthSanEmail;
        return this;
    }

    public boolean isTlsClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public Client setTlsClientCertificateBoundAccessTokens(boolean use) {
        this.tlsClientCertificateBoundAccessTokens = use;
        return this;
    }

    public String getSelfSignedCertificateKeyId() {
        return this.selfSignedCertificateKeyId;
    }

    public Client setSelfSignedCertificateKeyId(String keyId) {
        this.selfSignedCertificateKeyId = keyId;
        return this;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public Client setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
        return this;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public Client setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
        return this;
    }

    public JWSAlg getAuthorizationSignAlg() {
        return this.authorizationSignAlg;
    }

    public Client setAuthorizationSignAlg(JWSAlg alg) {
        this.authorizationSignAlg = alg;
        return this;
    }

    public JWEAlg getAuthorizationEncryptionAlg() {
        return this.authorizationEncryptionAlg;
    }

    public Client setAuthorizationEncryptionAlg(JWEAlg alg) {
        this.authorizationEncryptionAlg = alg;
        return this;
    }

    public JWEEnc getAuthorizationEncryptionEnc() {
        return this.authorizationEncryptionEnc;
    }

    public Client setAuthorizationEncryptionEnc(JWEEnc enc) {
        this.authorizationEncryptionEnc = enc;
        return this;
    }

    public DeliveryMode getBcDeliveryMode() {
        return this.bcDeliveryMode;
    }

    public Client setBcDeliveryMode(DeliveryMode mode) {
        this.bcDeliveryMode = mode;
        return this;
    }

    public URI getBcNotificationEndpoint() {
        return this.bcNotificationEndpoint;
    }

    public Client setBcNotificationEndpoint(URI endpoint) {
        this.bcNotificationEndpoint = endpoint;
        return this;
    }

    public JWSAlg getBcRequestSignAlg() {
        return this.bcRequestSignAlg;
    }

    public Client setBcRequestSignAlg(JWSAlg alg) {
        this.bcRequestSignAlg = alg;
        return this;
    }

    public boolean isBcUserCodeRequired() {
        return this.bcUserCodeRequired;
    }

    public Client setBcUserCodeRequired(boolean required) {
        this.bcUserCodeRequired = required;
        return this;
    }

    public boolean isDynamicallyRegistered() {
        return this.dynamicallyRegistered;
    }

    public Client setDynamicallyRegistered(boolean dynamicallyRegistered) {
        this.dynamicallyRegistered = dynamicallyRegistered;
        return this;
    }

    public String getRegistrationAccessTokenHash() {
        return this.registrationAccessTokenHash;
    }

    public Client setRegistrationAccessTokenHash(String registrationAccessToken) {
        this.registrationAccessTokenHash = registrationAccessToken;
        return this;
    }

    public String[] getAuthorizationDetailsTypes() {
        return this.authorizationDetailsTypes;
    }

    public Client setAuthorizationDetailsTypes(String[] types) {
        this.authorizationDetailsTypes = types;
        return this;
    }

    public boolean isParRequired() {
        return this.parRequired;
    }

    public Client setParRequired(boolean required) {
        this.parRequired = required;
        return this;
    }

    public boolean isRequestObjectRequired() {
        return this.requestObjectRequired;
    }

    public Client setRequestObjectRequired(boolean required) {
        this.requestObjectRequired = required;
        return this;
    }

    public Pair[] getAttributes() {
        return this.attributes;
    }

    public Client setAttributes(Pair[] attributes) {
        this.attributes = attributes;
        return this;
    }

    public Client loadAttributes(Iterable<Pair> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return this;
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Pair attribute : attributes) {
            if (attribute == null || attribute.getKey() == null) continue;
            list.add(attribute);
        }
        int size = list.size();
        if (size == 0) {
            this.attributes = null;
            return this;
        }
        Pair[] array = new Pair[size];
        this.attributes = list.toArray(array);
        return this;
    }

    public String getCustomMetadata() {
        return this.customMetadata;
    }

    public Client setCustomMetadata(String metadata) {
        this.customMetadata = metadata;
        return this;
    }

    public boolean isFrontChannelRequestObjectEncryptionRequired() {
        return this.frontChannelRequestObjectEncryptionRequired;
    }

    public Client setFrontChannelRequestObjectEncryptionRequired(boolean required) {
        this.frontChannelRequestObjectEncryptionRequired = required;
        return this;
    }

    public boolean isRequestObjectEncryptionAlgMatchRequired() {
        return this.requestObjectEncryptionAlgMatchRequired;
    }

    public Client setRequestObjectEncryptionAlgMatchRequired(boolean required) {
        this.requestObjectEncryptionAlgMatchRequired = required;
        return this;
    }

    public boolean isRequestObjectEncryptionEncMatchRequired() {
        return this.requestObjectEncryptionEncMatchRequired;
    }

    public Client setRequestObjectEncryptionEncMatchRequired(boolean required) {
        this.requestObjectEncryptionEncMatchRequired = required;
        return this;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Client setDigestAlgorithm(String algorithm) {
        this.digestAlgorithm = algorithm;
        return this;
    }
}

