/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum AttachmentType {
    EMBEDDED(1, "embedded"),
    EXTERNAL(2, "external");

    private static final AttachmentType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private AttachmentType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static AttachmentType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static AttachmentType parse(String type) {
        if (type == null) {
            return null;
        }
        for (AttachmentType entry : sValues) {
            if (!entry.mString.equals(type)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<AttachmentType> set) {
        return sHelper.toBits(set);
    }

    public static AttachmentType[] toArray(int bits) {
        return (AttachmentType[])sHelper.toArray(bits);
    }

    public static EnumSet<AttachmentType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<AttachmentType> toSet(AttachmentType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = AttachmentType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<AttachmentType> {
        public Helper(AttachmentType[] values) {
            super(AttachmentType.class, (Enum[])values);
        }

        @Override
        protected short getValue(AttachmentType entry) {
            return entry.getValue();
        }

        protected AttachmentType[] newArray(int size) {
            return new AttachmentType[size];
        }
    }
}

