/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public enum ClaimsScope {
    PROFILE("profile", "name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"),
    EMAIL("email", "email", "email_verified"),
    ADDRESS("address", "address"),
    PHONE("phone", "phone_number", "phone_number_verified");

    private static final Map<String, ClaimsScope> sNameMap;
    private final String mName;
    private final SortedSet<String> mClaims;

    private ClaimsScope(String name, String ... claims) {
        this.mName = name;
        TreeSet<String> set = new TreeSet<String>();
        for (String claim : claims) {
            set.add(claim);
        }
        this.mClaims = Collections.unmodifiableSortedSet(set);
    }

    public String getName() {
        return this.mName;
    }

    public SortedSet<String> getClaims() {
        return this.mClaims;
    }

    public static ClaimsScope getByName(String name) {
        return sNameMap.get(name);
    }

    static {
        sNameMap = new HashMap<String, ClaimsScope>();
        for (ClaimsScope value : ClaimsScope.values()) {
            sNameMap.put(value.mName, value);
        }
    }
}

