/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum GMAction {
    CREATE(1, "create"),
    QUERY(2, "query"),
    REPLACE(3, "replace"),
    REVOKE(4, "revoke"),
    UPDATE(5, "update");

    private static final GMAction[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private GMAction(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static GMAction getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static GMAction parse(String action) {
        if (action == null) {
            return null;
        }
        for (GMAction entry : sValues) {
            if (!entry.mString.equals(action)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<GMAction> set) {
        return sHelper.toBits(set);
    }

    public static GMAction[] toArray(int bits) {
        return (GMAction[])sHelper.toArray(bits);
    }

    public static EnumSet<GMAction> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<GMAction> toSet(GMAction[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = GMAction.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<GMAction> {
        public Helper(GMAction[] values) {
            super(GMAction.class, (Enum[])values);
        }

        @Override
        protected short getValue(GMAction entry) {
            return entry.getValue();
        }

        protected GMAction[] newArray(int size) {
            return new GMAction[size];
        }
    }
}

