/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum GrantType {
    AUTHORIZATION_CODE(1, "authorization_code"),
    IMPLICIT(2, "implicit"),
    PASSWORD(3, "password"),
    CLIENT_CREDENTIALS(4, "client_credentials"),
    REFRESH_TOKEN(5, "refresh_token"),
    CIBA(6, "urn:openid:params:grant-type:ciba"),
    DEVICE_CODE(7, "urn:ietf:params:oauth:grant-type:device_code");

    private static final GrantType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private GrantType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static GrantType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static GrantType parse(String grantType) {
        if (grantType == null) {
            return null;
        }
        for (GrantType entry : sValues) {
            if (!entry.mString.equals(grantType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<GrantType> set) {
        return sHelper.toBits(set);
    }

    public static GrantType[] toArray(int bits) {
        return (GrantType[])sHelper.toArray(bits);
    }

    public static EnumSet<GrantType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<GrantType> toSet(GrantType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = GrantType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<GrantType> {
        public Helper(GrantType[] values) {
            super(GrantType.class, (Enum[])values);
        }

        @Override
        protected short getValue(GrantType entry) {
            return entry.getValue();
        }

        protected GrantType[] newArray(int size) {
            return new GrantType[size];
        }
    }
}

