/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum StandardScope {
    ADDRESS(1, "address"),
    EMAIL(2, "email"),
    OPENID(3, "openid"),
    OFFLINE_ACCESS(4, "offline_access"),
    PHONE(5, "phone"),
    PROFILE(6, "profile");

    private static final StandardScope[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private StandardScope(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static StandardScope getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static StandardScope parse(String scope) {
        if (scope == null) {
            return null;
        }
        for (StandardScope entry : sValues) {
            if (!entry.mString.equals(scope)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<StandardScope> set) {
        return sHelper.toBits(set);
    }

    public static StandardScope[] toArray(int bits) {
        return (StandardScope[])sHelper.toArray(bits);
    }

    public static EnumSet<StandardScope> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<StandardScope> toSet(StandardScope[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = StandardScope.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<StandardScope> {
        public Helper(StandardScope[] values) {
            super(StandardScope.class, (Enum[])values);
        }

        @Override
        protected short getValue(StandardScope entry) {
            return entry.getValue();
        }

        protected StandardScope[] newArray(int size) {
            return new StandardScope[size];
        }
    }
}

