/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.util.MapUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class CredentialIssuerMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private URI credentialIssuer;
    private URI authorizationServer;
    private URI credentialEndpoint;
    private URI batchCredentialEndpoint;
    private String credentialsSupported;

    public CredentialIssuerMetadata() {
    }

    public CredentialIssuerMetadata(CredentialIssuerMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.credentialIssuer = metadata.getCredentialIssuer();
        this.authorizationServer = metadata.getAuthorizationServer();
        this.credentialEndpoint = metadata.getCredentialEndpoint();
        this.batchCredentialEndpoint = metadata.getBatchCredentialEndpoint();
        this.credentialsSupported = metadata.getCredentialsSupported();
    }

    public URI getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialIssuerMetadata setCredentialIssuer(URI issuer) {
        this.credentialIssuer = issuer;
        return this;
    }

    public URI getAuthorizationServer() {
        return this.authorizationServer;
    }

    public CredentialIssuerMetadata setAuthorizationServer(URI server) {
        this.authorizationServer = server;
        return this;
    }

    public URI getCredentialEndpoint() {
        return this.credentialEndpoint;
    }

    public CredentialIssuerMetadata setCredentialEndpoint(URI endpoint) {
        this.credentialEndpoint = endpoint;
        return this;
    }

    public URI getBatchCredentialEndpoint() {
        return this.batchCredentialEndpoint;
    }

    public CredentialIssuerMetadata setBatchCredentialEndpoint(URI endpoint) {
        this.batchCredentialEndpoint = endpoint;
        return this;
    }

    public String getCredentialsSupported() {
        return this.credentialsSupported;
    }

    public CredentialIssuerMetadata setCredentialsSupported(String credentialsSupported) {
        this.credentialsSupported = credentialsSupported;
        return this;
    }

    public boolean isEmpty() {
        return this.credentialIssuer == null && this.authorizationServer == null && this.credentialEndpoint == null && this.batchCredentialEndpoint == null && this.credentialsSupported == null;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        MapUtils.put(map, "credential_issuer", this.credentialIssuer, false);
        MapUtils.put(map, "authorization_server", this.authorizationServer, false);
        MapUtils.put(map, "credential_endpoint", this.credentialEndpoint, false);
        MapUtils.put(map, "batch_credential_endpoint", this.batchCredentialEndpoint, false);
        try {
            MapUtils.putJsonArray(map, "credentials_supported", this.credentialsSupported, false);
        }
        catch (Exception cause) {
            throw new IllegalStateException("The value of the 'credentialsSupported' property failed to be parsed as a JSON array.", cause);
        }
        return map;
    }
}

