/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.AuthzDetails;
import com.authlete.common.dto.AuthzDetailsDeserializer;
import com.authlete.common.dto.Grant;
import com.authlete.common.dto.GrantScope;
import com.authlete.common.util.BaseJsonDeserializer;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class GrantDeserializer
extends BaseJsonDeserializer
implements JsonDeserializer<Grant> {
    public Grant deserialize(JsonElement jelement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (jelement == null || jelement.isJsonNull()) {
            return null;
        }
        JsonObject jGrant = jelement.getAsJsonObject();
        Grant grant = new Grant();
        this.addScopes(jGrant, grant);
        this.addClaims(jGrant, grant);
        this.addAuthorizationDetails(jGrant, grant);
        return grant;
    }

    private void addScopes(JsonObject jGrant, Grant grant) {
        JsonArray jScopes = this.getAsArrayFromObject(jGrant, "scopes");
        if (jScopes == null || jScopes.isJsonNull()) {
            return;
        }
        int size = jScopes.size();
        GrantScope[] scopes = new GrantScope[size];
        Gson gson = new Gson();
        for (int i = 0; i < size; ++i) {
            scopes[i] = (GrantScope)gson.fromJson(jScopes.get(i), GrantScope.class);
        }
        grant.setScopes(scopes);
    }

    private void addClaims(JsonObject jGrant, Grant grant) {
        String[] claims = this.getAsStringArrayFromObject(jGrant, "claims");
        grant.setClaims(claims);
    }

    private void addAuthorizationDetails(JsonObject jGrant, Grant grant) {
        AuthzDetails details = new AuthzDetailsDeserializer().deserialize((JsonElement)this.getAsArrayFromObject(jGrant, "authorization_details"), null, null);
        grant.setAuthorizationDetails(details);
    }
}

