/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import com.authlete.common.util.Version;
import java.util.EnumSet;

public enum GrantType {
    AUTHORIZATION_CODE(1, "authorization_code", new Version(1, 1)),
    IMPLICIT(2, "implicit", new Version(1, 1)),
    PASSWORD(3, "password", new Version(1, 1)),
    CLIENT_CREDENTIALS(4, "client_credentials", new Version(1, 1)),
    REFRESH_TOKEN(5, "refresh_token", new Version(1, 1)),
    CIBA(6, "urn:openid:params:grant-type:ciba", new Version(2, 1)),
    DEVICE_CODE(7, "urn:ietf:params:oauth:grant-type:device_code", new Version(2, 1)),
    TOKEN_EXCHANGE(8, "urn:ietf:params:oauth:grant-type:token-exchange", new Version(2, 3)),
    JWT_BEARER(9, "urn:ietf:params:oauth:grant-type:jwt-bearer", new Version(2, 3)),
    PRE_AUTHORIZED_CODE(10, "urn:ietf:params:oauth:grant-type:pre-authorized_code", new Version(3, 0));

    private static final GrantType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;
    private final Version mVersion;

    private GrantType(short value, String string2, Version version) {
        this.mValue = value;
        this.mString = string2;
        this.mVersion = version;
    }

    public short getValue() {
        return this.mValue;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return this.mString;
    }

    public static GrantType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static GrantType parse(String grantType) {
        if (grantType == null) {
            return null;
        }
        for (GrantType entry : sValues) {
            if (!entry.mString.equals(grantType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<GrantType> set) {
        return sHelper.toBits(set);
    }

    public static GrantType[] toArray(int bits) {
        return (GrantType[])sHelper.toArray(bits);
    }

    public static EnumSet<GrantType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<GrantType> toSet(GrantType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = GrantType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<GrantType> {
        public Helper(GrantType[] values) {
            super(GrantType.class, (Enum[])values);
        }

        @Override
        protected short getValue(GrantType entry) {
            return entry.getValue();
        }

        protected GrantType[] newArray(int size) {
            return new GrantType[size];
        }
    }
}

