/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.api;

import java.util.Arrays;
import java.util.List;

public enum AccessRight {
    VIEW_CLIENT(true, true, new AccessRight[0]),
    MODIFY_CLIENT(true, true, VIEW_CLIENT),
    VIEW_SERVICE(false, true, VIEW_CLIENT),
    USE_SERVICE(false, true, VIEW_SERVICE, VIEW_CLIENT),
    CREATE_CLIENT(false, true, USE_SERVICE, VIEW_SERVICE, MODIFY_CLIENT, VIEW_CLIENT),
    MODIFY_SERVICE(false, true, USE_SERVICE, VIEW_SERVICE, CREATE_CLIENT, MODIFY_CLIENT, VIEW_CLIENT),
    VIEW_DEFAULT_SERVICE(false, false, new AccessRight[0]),
    CREATE_SERVICE(false, false, VIEW_DEFAULT_SERVICE),
    DELETE_SERVICE(false, true, new AccessRight[0]),
    ADMIN(false, false, VIEW_DEFAULT_SERVICE, CREATE_SERVICE, DELETE_SERVICE, USE_SERVICE, VIEW_SERVICE, MODIFY_SERVICE, CREATE_CLIENT, MODIFY_CLIENT, VIEW_CLIENT);

    public static final String AUTHLETE_API_V3 = "https://api.authlete.com/v3/";
    private final boolean serviceSpecific;
    private final boolean clientSpecific;
    private final List<AccessRight> includes;

    private AccessRight(boolean clientSpecific, boolean serviceSpecific, AccessRight ... includes) {
        this.serviceSpecific = serviceSpecific || clientSpecific;
        this.clientSpecific = clientSpecific;
        this.includes = Arrays.asList(includes);
    }

    public boolean isServiceSpecific() {
        return this.serviceSpecific;
    }

    public boolean isClientSpecific() {
        return this.clientSpecific;
    }

    public boolean canDo(long clientId, long serviceId, AccessRight compare) {
        if (this.serviceSpecific && serviceId <= 0L) {
            return false;
        }
        if (this.clientSpecific && (clientId <= 0L || serviceId <= 0L)) {
            return false;
        }
        return this.equals((Object)compare) || this.includes.contains((Object)compare);
    }

    public static AccessRight fromJson(String key) {
        try {
            return key == null ? null : AccessRight.valueOf(key.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toJson() {
        return this.name().toLowerCase();
    }
}

