/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.api;

import com.authlete.common.api.AuthleteApi;
import com.authlete.common.api.AuthleteApiException;
import com.authlete.common.api.ConnectionContext;
import com.authlete.common.api.Settings;
import com.authlete.common.conf.AuthleteConfiguration;
import com.authlete.common.dto.ApiResponse;
import com.authlete.common.dto.AuthorizationFailRequest;
import com.authlete.common.dto.AuthorizationFailResponse;
import com.authlete.common.dto.AuthorizationIssueRequest;
import com.authlete.common.dto.AuthorizationIssueResponse;
import com.authlete.common.dto.AuthorizationRequest;
import com.authlete.common.dto.AuthorizationResponse;
import com.authlete.common.dto.AuthorizedClientListResponse;
import com.authlete.common.dto.BackchannelAuthenticationCompleteRequest;
import com.authlete.common.dto.BackchannelAuthenticationCompleteResponse;
import com.authlete.common.dto.BackchannelAuthenticationFailRequest;
import com.authlete.common.dto.BackchannelAuthenticationFailResponse;
import com.authlete.common.dto.BackchannelAuthenticationIssueRequest;
import com.authlete.common.dto.BackchannelAuthenticationIssueResponse;
import com.authlete.common.dto.BackchannelAuthenticationRequest;
import com.authlete.common.dto.BackchannelAuthenticationResponse;
import com.authlete.common.dto.Client;
import com.authlete.common.dto.ClientAuthorizationDeleteRequest;
import com.authlete.common.dto.ClientAuthorizationGetListRequest;
import com.authlete.common.dto.ClientAuthorizationUpdateRequest;
import com.authlete.common.dto.ClientListResponse;
import com.authlete.common.dto.ClientLockFlagUpdateRequest;
import com.authlete.common.dto.ClientRegistrationRequest;
import com.authlete.common.dto.ClientRegistrationResponse;
import com.authlete.common.dto.ClientSecretRefreshResponse;
import com.authlete.common.dto.ClientSecretUpdateRequest;
import com.authlete.common.dto.ClientSecretUpdateResponse;
import com.authlete.common.dto.CredentialBatchIssueRequest;
import com.authlete.common.dto.CredentialBatchIssueResponse;
import com.authlete.common.dto.CredentialBatchParseRequest;
import com.authlete.common.dto.CredentialBatchParseResponse;
import com.authlete.common.dto.CredentialDeferredIssueRequest;
import com.authlete.common.dto.CredentialDeferredIssueResponse;
import com.authlete.common.dto.CredentialDeferredParseRequest;
import com.authlete.common.dto.CredentialDeferredParseResponse;
import com.authlete.common.dto.CredentialIssuerJwksRequest;
import com.authlete.common.dto.CredentialIssuerJwksResponse;
import com.authlete.common.dto.CredentialIssuerMetadataRequest;
import com.authlete.common.dto.CredentialIssuerMetadataResponse;
import com.authlete.common.dto.CredentialOfferCreateRequest;
import com.authlete.common.dto.CredentialOfferCreateResponse;
import com.authlete.common.dto.CredentialOfferInfoRequest;
import com.authlete.common.dto.CredentialOfferInfoResponse;
import com.authlete.common.dto.CredentialSingleIssueRequest;
import com.authlete.common.dto.CredentialSingleIssueResponse;
import com.authlete.common.dto.CredentialSingleParseRequest;
import com.authlete.common.dto.CredentialSingleParseResponse;
import com.authlete.common.dto.DeviceAuthorizationRequest;
import com.authlete.common.dto.DeviceAuthorizationResponse;
import com.authlete.common.dto.DeviceCompleteRequest;
import com.authlete.common.dto.DeviceCompleteResponse;
import com.authlete.common.dto.DeviceVerificationRequest;
import com.authlete.common.dto.DeviceVerificationResponse;
import com.authlete.common.dto.FederationConfigurationRequest;
import com.authlete.common.dto.FederationConfigurationResponse;
import com.authlete.common.dto.FederationRegistrationRequest;
import com.authlete.common.dto.FederationRegistrationResponse;
import com.authlete.common.dto.GMRequest;
import com.authlete.common.dto.GMResponse;
import com.authlete.common.dto.GrantedScopesGetResponse;
import com.authlete.common.dto.HskCreateRequest;
import com.authlete.common.dto.HskListResponse;
import com.authlete.common.dto.HskResponse;
import com.authlete.common.dto.IDTokenReissueRequest;
import com.authlete.common.dto.IDTokenReissueResponse;
import com.authlete.common.dto.IntrospectionRequest;
import com.authlete.common.dto.IntrospectionResponse;
import com.authlete.common.dto.JoseVerifyRequest;
import com.authlete.common.dto.JoseVerifyResponse;
import com.authlete.common.dto.PushedAuthReqRequest;
import com.authlete.common.dto.PushedAuthReqResponse;
import com.authlete.common.dto.RevocationRequest;
import com.authlete.common.dto.RevocationResponse;
import com.authlete.common.dto.Service;
import com.authlete.common.dto.ServiceConfigurationRequest;
import com.authlete.common.dto.ServiceListResponse;
import com.authlete.common.dto.StandardIntrospectionRequest;
import com.authlete.common.dto.StandardIntrospectionResponse;
import com.authlete.common.dto.TokenCreateRequest;
import com.authlete.common.dto.TokenCreateResponse;
import com.authlete.common.dto.TokenFailRequest;
import com.authlete.common.dto.TokenFailResponse;
import com.authlete.common.dto.TokenIssueRequest;
import com.authlete.common.dto.TokenIssueResponse;
import com.authlete.common.dto.TokenListResponse;
import com.authlete.common.dto.TokenRequest;
import com.authlete.common.dto.TokenResponse;
import com.authlete.common.dto.TokenRevokeRequest;
import com.authlete.common.dto.TokenRevokeResponse;
import com.authlete.common.dto.TokenUpdateRequest;
import com.authlete.common.dto.TokenUpdateResponse;
import com.authlete.common.dto.UserInfoIssueRequest;
import com.authlete.common.dto.UserInfoIssueResponse;
import com.authlete.common.dto.UserInfoRequest;
import com.authlete.common.dto.UserInfoResponse;
import com.authlete.common.util.Utils;
import com.authlete.common.web.BasicCredentials;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AuthleteApiImpl
implements AuthleteApi {
    private static String UTF_8 = "UTF-8";
    private static final String AUTH_AUTHORIZATION_API_PATH = "/api/auth/authorization";
    private static final String AUTH_AUTHORIZATION_FAIL_API_PATH = "/api/auth/authorization/fail";
    private static final String AUTH_AUTHORIZATION_ISSUE_API_PATH = "/api/auth/authorization/issue";
    private static final String AUTH_TOKEN_API_PATH = "/api/auth/token";
    private static final String AUTH_TOKEN_CREATE_API_PATH = "/api/auth/token/create";
    private static final String AUTH_TOKEN_DELETE_API_PATH = "/api/auth/token/delete/%s";
    private static final String AUTH_TOKEN_FAIL_API_PATH = "/api/auth/token/fail";
    private static final String AUTH_TOKEN_ISSUE_API_PATH = "/api/auth/token/issue";
    private static final String AUTH_TOKEN_REVOKE_API_PATH = "/api/auth/token/revoke";
    private static final String AUTH_TOKEN_UPDATE_API_PATH = "/api/auth/token/update";
    private static final String AUTH_TOKEN_GET_LIST_API_PATH = "/api/auth/token/get/list";
    private static final String AUTH_REVOCATION_API_PATH = "/api/auth/revocation";
    private static final String AUTH_USERINFO_API_PATH = "/api/auth/userinfo";
    private static final String AUTH_USERINFO_ISSUE_API_PATH = "/api/auth/userinfo/issue";
    private static final String AUTH_INTROSPECTION_API_PATH = "/api/auth/introspection";
    private static final String AUTH_INTROSPECTION_STANDARD_API_PATH = "/api/auth/introspection/standard";
    private static final String SERVICE_CONFIGURATION_API_PATH = "/api/service/configuration";
    private static final String SERVICE_CREATE_API_PATH = "/api/service/create";
    private static final String SERVICE_DELETE_API_PATH = "/api/service/delete/%d";
    private static final String SERVICE_GET_API_PATH = "/api/service/get/%d";
    private static final String SERVICE_GET_LIST_API_PATH = "/api/service/get/list";
    private static final String SERVICE_JWKS_GET_API_PATH = "/api/service/jwks/get";
    private static final String SERVICE_UPDATE_API_PATH = "/api/service/update/%d";
    private static final String CLIENT_CREATE_API_PATH = "/api/client/create";
    private static final String CLIENT_REGISTRATION_API_PATH = "/api/client/registration";
    private static final String CLIENT_REGISTRATION_GET_API_PATH = "/api/client/registration/get";
    private static final String CLIENT_REGISTRATION_UPDATE_API_PATH = "/api/client/registration/update";
    private static final String CLIENT_REGISTRATION_DELETE_API_PATH = "/api/client/registration/delete";
    private static final String CLIENT_DELETE_API_PATH = "/api/client/delete/%s";
    private static final String CLIENT_GET_API_PATH = "/api/client/get/%s";
    private static final String CLIENT_GET_LIST_API_PATH = "/api/client/get/list";
    private static final String CLIENT_SECRET_REFRESH_API_PATH = "/api/client/secret/refresh/%s";
    private static final String CLIENT_SECRET_UPDATE_API_PATH = "/api/client/secret/update/%s";
    private static final String CLIENT_UPDATE_API_PATH = "/api/client/update/%d";
    private static final String REQUESTABLE_SCOPES_DELETE_API_PATH = "/api/client/extension/requestable_scopes/delete/%d";
    private static final String REQUESTABLE_SCOPES_GET_API_PATH = "/api/client/extension/requestable_scopes/get/%d";
    private static final String REQUESTABLE_SCOPES_UPDATE_API_PATH = "/api/client/extension/requestable_scopes/update/%d";
    private static final String GRANTED_SCOPES_GET_API_PATH = "/api/client/granted_scopes/get/%d";
    private static final String GRANTED_SCOPES_DELETE_API_PATH = "/api/client/granted_scopes/delete/%d";
    private static final String CLIENT_AUTHORIZATION_DELETE_API_PATH = "/api/client/authorization/delete/%d";
    private static final String CLIENT_AUTHORIZATION_GET_LIST_API_PATH = "/api/client/authorization/get/list";
    private static final String CLIENT_AUTHORIZATION_UPDATE_API_PATH = "/api/client/authorization/update/%d";
    private static final String JOSE_VERIFY_API_PATH = "/api/jose/verify";
    private static final String BC_AUTHENTICATION_API_PATH = "/api/backchannel/authentication";
    private static final String BC_AUTHENTICATION_COMPLETE_API_PATH = "/api/backchannel/authentication/complete";
    private static final String BC_AUTHENTICATION_FAIL_API_PATH = "/api/backchannel/authentication/fail";
    private static final String BC_AUTHENTICATION_ISSUE_API_PATH = "/api/backchannel/authentication/issue";
    private static final String DEVICE_AUTHORIZATION_API_PATH = "/api/device/authorization";
    private static final String DEVICE_COMPLETE_API_PATH = "/api/device/complete";
    private static final String DEVICE_VERIFICATION_API_PATH = "/api/device/verification";
    private static final String PUSHED_AUTH_REQ_API_PATH = "/api/pushed_auth_req";
    private static final String HSK_CREATE_API_PATH = "/api/hsk/create";
    private static final String HSK_DELETE_API_PATH = "/api/hsk/delete/%s";
    private static final String HSK_GET_API_PATH = "/api/hsk/get/%s";
    private static final String HSK_GET_LIST_API_PATH = "/api/hsk/get/list";
    private static final String ECHO_API_PATH = "/api/misc/echo";
    private static final String GM_API_PATH = "/api/gm";
    private static final String CLIENT_LOCK_FLAG_UPDATE_API_PATH = "/api/client/lock_flag/update";
    private static final String FEDERATION_CONFIGURATION_API_PATH = "/api/federation/configuration";
    private static final String FEDERATION_REGISTRATION_API_PATH = "/api/federation/registration";
    private static final String VCI_METADATA_API_PATH = "/api/vci/metadata";
    private static final String VCI_JWKS_API_PATH = "/api/vci/jwks";
    private static final String VCI_OFFER_CREATE_API_PATH = "/api/vci/offer/create";
    private static final String VCI_OFFER_INFO_API_PATH = "/api/vci/offer/info";
    private static final String VCI_SINGLE_PARSE_API_PATH = "/api/vci/single/parse";
    private static final String VCI_SINGLE_ISSUE_API_PATH = "/api/vci/single/issue";
    private static final String VCI_BATCH_PARSE_API_PATH = "/api/vci/batch/parse";
    private static final String VCI_BATCH_ISSUE_API_PATH = "/api/vci/batch/issue";
    private static final String VCI_DEFERRED_PARSE_API_PATH = "/api/vci/deferred/parse";
    private static final String VCI_DEFERRED_ISSUE_API_PATH = "/api/vci/deferred/issue";
    private static final String ID_TOKEN_REISSUE_API_PATH = "/api/idtoken/reissue";
    private final String mBaseUrl;
    private final BasicCredentials mServiceOwnerCredentials;
    private final BasicCredentials mServiceCredentials;
    private final Settings mSettings;

    public AuthleteApiImpl(AuthleteConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null.");
        }
        this.mServiceOwnerCredentials = AuthleteApiImpl.createServiceOwnerCredentials(configuration);
        this.mServiceCredentials = AuthleteApiImpl.createServiceCredentials(configuration);
        this.mBaseUrl = AuthleteApiImpl.createBaseUrl(configuration);
        this.mSettings = new Settings();
    }

    private static BasicCredentials createServiceOwnerCredentials(AuthleteConfiguration configuration) {
        String key = configuration.getServiceOwnerApiKey();
        String secret = configuration.getServiceOwnerApiSecret();
        return new BasicCredentials(key, secret);
    }

    private static BasicCredentials createServiceCredentials(AuthleteConfiguration configuration) {
        String key = configuration.getServiceApiKey();
        String secret = configuration.getServiceApiSecret();
        return new BasicCredentials(key, secret);
    }

    private static String createBaseUrl(AuthleteConfiguration configuration) {
        String baseUrl = configuration.getBaseUrl();
        if (baseUrl == null) {
            throw new IllegalArgumentException("The configuration does not have information about the base URL.");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The base URL is malformed.", e);
        }
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private <TResponse> TResponse callServiceOwnerGetApi(String path, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callServiceOwnerGetApi(path, null, responseClass);
    }

    private <TResponse> TResponse callServiceOwnerGetApi(String path, Map<String, String> queryParams, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callGetApi(this.mServiceOwnerCredentials, path, queryParams, responseClass);
    }

    private <TResponse> TResponse callServiceGetApi(String path, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callServiceGetApi(path, null, responseClass);
    }

    private <TResponse> TResponse callServiceGetApi(String path, Map<String, String> queryParams, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callGetApi(this.mServiceCredentials, path, queryParams, responseClass);
    }

    private <TResponse> TResponse callGetApi(BasicCredentials credentials, String path, Map<String, String> queryParams, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callApi(HttpMethod.GET, credentials, path, queryParams, null, responseClass);
    }

    private <TResponse> TResponse callServiceOwnerPostApi(String path, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callServiceOwnerPostApi(path, null, requestBody, responseClass);
    }

    private <TResponse> TResponse callServiceOwnerPostApi(String path, Map<String, String> queryParams, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callPostApi(this.mServiceOwnerCredentials, path, queryParams, requestBody, responseClass);
    }

    private <TResponse> TResponse callServicePostApi(String path, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callServicePostApi(path, null, requestBody, responseClass);
    }

    private <TResponse> TResponse callServicePostApi(String path, Map<String, String> queryParams, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callPostApi(this.mServiceCredentials, path, queryParams, requestBody, responseClass);
    }

    private <TResponse> TResponse callPostApi(BasicCredentials credentials, String path, Map<String, String> queryParams, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        return this.callApi(HttpMethod.POST, credentials, path, queryParams, requestBody, responseClass);
    }

    private <TResponse> void callServiceOwnerDeleteApi(String path) throws AuthleteApiException {
        this.callServiceOwnerDeleteApi(path, null);
    }

    private <TResponse> void callServiceOwnerDeleteApi(String path, Map<String, String> queryParams) throws AuthleteApiException {
        this.callDeleteApi(this.mServiceOwnerCredentials, path, queryParams);
    }

    private <TResponse> void callServiceDeleteApi(String path) throws AuthleteApiException {
        this.callServiceDeleteApi(path, null);
    }

    private <TResponse> void callServiceDeleteApi(String path, Map<String, String> queryParams) throws AuthleteApiException {
        this.callDeleteApi(this.mServiceCredentials, path, queryParams);
    }

    private <TResponse> void callDeleteApi(BasicCredentials credentials, String path, Map<String, String> queryParams) throws AuthleteApiException {
        this.callApi(HttpMethod.DELETE, credentials, path, queryParams, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TResponse> TResponse callApi(HttpMethod method, BasicCredentials credentials, String path, Map<String, String> queryParams, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        try (ConnectionContext ctx = AuthleteApiImpl.createConnection(method, credentials, this.mBaseUrl, path, queryParams, this.mSettings);){
            TResponse TResponse = this.communicate(ctx, requestBody, responseClass);
            return TResponse;
        }
    }

    private static ConnectionContext createConnection(HttpMethod method, BasicCredentials credentials, String baseUrl, String path, Map<String, String> queryParams, Settings settings) throws AuthleteApiException {
        try {
            return AuthleteApiImpl.openConnection(method, credentials, baseUrl, path, queryParams, settings);
        }
        catch (Throwable cause) {
            throw AuthleteApiImpl.createAuthleteApiException(cause, null);
        }
    }

    private static ConnectionContext openConnection(HttpMethod method, BasicCredentials credentials, String baseUrl, String path, Map<String, String> queryParams, Settings settings) throws IOException {
        URL url = AuthleteApiImpl.buildUrl(baseUrl, path, queryParams);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(method.name());
        if (credentials != null) {
            con.setRequestProperty("Authorization", credentials.format());
        }
        con.setRequestProperty("Accept", "application/json");
        con.setDoInput(true);
        con.setConnectTimeout(settings.getConnectionTimeout());
        con.setReadTimeout(settings.getReadTimeout());
        return new ConnectionContext(con);
    }

    private static URL buildUrl(String baseUrl, String path, Map<String, String> queryParams) throws MalformedURLException {
        StringBuffer buf = new StringBuffer(baseUrl).append(path);
        AuthleteApiImpl.appendQueryParams(buf, queryParams);
        return new URL(buf.toString());
    }

    private static void appendQueryParams(StringBuffer buf, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return;
        }
        buf.append('?');
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = AuthleteApiImpl.toQueryParamKey(entry.getKey());
            if (key == null) continue;
            String value = AuthleteApiImpl.toQueryParamValue(entry.getValue());
            buf.append(key).append('=').append(value).append('&');
        }
        buf.setLength(buf.length() - 1);
    }

    private static String toQueryParamKey(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        return AuthleteApiImpl.urlEncode(str);
    }

    private static String toQueryParamValue(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return AuthleteApiImpl.urlEncode(str);
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private <TResponse> TResponse communicate(ConnectionContext ctx, Object requestBody, Class<TResponse> responseClass) throws AuthleteApiException {
        String responseBody;
        if (requestBody != null) {
            AuthleteApiImpl.writeRequestBody(ctx, requestBody);
        }
        if ((responseBody = AuthleteApiImpl.readResponseBody(ctx)) == null) {
            return null;
        }
        if (responseClass == String.class || responseClass == null) {
            return (TResponse)responseBody;
        }
        return Utils.fromJson(responseBody, responseClass);
    }

    private static void writeRequestBody(ConnectionContext ctx, Object requestBody) throws AuthleteApiException {
        ctx.property("Content-Type", "application/json");
        ctx.doOutput(true);
        try {
            AuthleteApiImpl.writeContent(ctx, requestBody);
        }
        catch (Throwable cause) {
            throw AuthleteApiImpl.createAuthleteApiException(cause, ctx);
        }
    }

    private static void writeContent(ConnectionContext ctx, Object requestBody) throws IOException {
        String json = Utils.toJson(requestBody);
        byte[] bytes = AuthleteApiImpl.getBytesUTF8(json);
        OutputStream out = ctx.outputStream();
        out.write(bytes);
        out.flush();
    }

    private static byte[] getBytesUTF8(String str) {
        try {
            return str.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String readResponseBody(ConnectionContext ctx) throws AuthleteApiException {
        try {
            return AuthleteApiImpl.readContent(ctx);
        }
        catch (Throwable cause) {
            throw AuthleteApiImpl.createAuthleteApiException(cause, ctx);
        }
    }

    private static String readContent(ConnectionContext ctx) throws IOException {
        return AuthleteApiImpl.readInputStream(ctx.inputStream(), ctx.contentLength(), UTF_8);
    }

    private static String readInputStream(InputStream in, int expectedLength, String charset) throws IOException {
        ByteArrayOutputStream out = AuthleteApiImpl.createByteArrayOutputStream(expectedLength);
        AuthleteApiImpl.copy(new BufferedInputStream(in), out);
        return out.toString(charset);
    }

    private static ByteArrayOutputStream createByteArrayOutputStream(int expectedLength) {
        if (expectedLength < 0) {
            return new ByteArrayOutputStream();
        }
        return new ByteArrayOutputStream(expectedLength);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8096];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    private static AuthleteApiException createAuthleteApiException(Throwable cause, ConnectionContext ctx) {
        String message = cause.getMessage();
        HttpURLConnection con = ctx.connection();
        if (con == null) {
            return new AuthleteApiException(message, cause);
        }
        int statusCode = AuthleteApiImpl.extractStatusCode(con);
        String statusMessage = AuthleteApiImpl.extractStatusMessage(con);
        String responseBody = AuthleteApiImpl.extractErrorData(ctx);
        Map<String, List<String>> headers = con.getHeaderFields();
        return new AuthleteApiException(message, cause, statusCode, statusMessage, responseBody, headers);
    }

    private static int extractStatusCode(HttpURLConnection con) {
        int statusCode;
        try {
            statusCode = con.getResponseCode();
        }
        catch (Throwable cause) {
            return 0;
        }
        if (statusCode < 0) {
            return 0;
        }
        return statusCode;
    }

    private static String extractStatusMessage(HttpURLConnection con) {
        try {
            return con.getResponseMessage();
        }
        catch (Throwable cause) {
            return null;
        }
    }

    private static String extractErrorData(ConnectionContext ctx) {
        try {
            InputStream in = ctx.errorStream();
            if (in != null) {
                return AuthleteApiImpl.readInputStream(in, -1, UTF_8);
            }
            return AuthleteApiImpl.readContent(ctx);
        }
        catch (Throwable cause) {
            return null;
        }
    }

    private static Map<String, String> buildMap(Object ... pairs) {
        int len = pairs.length;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            String key = (String)pairs[i];
            Object obj = len <= ++i ? null : pairs[i];
            String val = obj == null ? null : obj.toString();
            map.put(key, val);
        }
        return map;
    }

    @Override
    public AuthorizationResponse authorization(AuthorizationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_AUTHORIZATION_API_PATH, request, AuthorizationResponse.class);
    }

    @Override
    public AuthorizationFailResponse authorizationFail(AuthorizationFailRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_AUTHORIZATION_FAIL_API_PATH, request, AuthorizationFailResponse.class);
    }

    @Override
    public AuthorizationIssueResponse authorizationIssue(AuthorizationIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_AUTHORIZATION_ISSUE_API_PATH, request, AuthorizationIssueResponse.class);
    }

    @Override
    public TokenResponse token(TokenRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_API_PATH, request, TokenResponse.class);
    }

    @Override
    public TokenCreateResponse tokenCreate(TokenCreateRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_CREATE_API_PATH, request, TokenCreateResponse.class);
    }

    @Override
    public void tokenDelete(String token) throws AuthleteApiException {
        this.callServiceDeleteApi(String.format(AUTH_TOKEN_DELETE_API_PATH, token));
    }

    @Override
    public TokenFailResponse tokenFail(TokenFailRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_FAIL_API_PATH, request, TokenFailResponse.class);
    }

    @Override
    public TokenIssueResponse tokenIssue(TokenIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_ISSUE_API_PATH, request, TokenIssueResponse.class);
    }

    @Override
    public TokenRevokeResponse tokenRevoke(TokenRevokeRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_REVOKE_API_PATH, request, TokenRevokeResponse.class);
    }

    @Override
    public TokenUpdateResponse tokenUpdate(TokenUpdateRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_TOKEN_UPDATE_API_PATH, request, TokenUpdateResponse.class);
    }

    @Override
    public TokenListResponse getTokenList() throws AuthleteApiException {
        return this.callServiceGetApi(AUTH_TOKEN_GET_LIST_API_PATH, TokenListResponse.class);
    }

    @Override
    public TokenListResponse getTokenList(String clientIdentifier, String subject) throws AuthleteApiException {
        return this.callServiceGetApi(AUTH_TOKEN_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("clientIdentifier", clientIdentifier, "subject", subject), TokenListResponse.class);
    }

    @Override
    public TokenListResponse getTokenList(int start, int end) throws AuthleteApiException {
        return this.callServiceGetApi(AUTH_TOKEN_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("start", start, "end", end), TokenListResponse.class);
    }

    @Override
    public TokenListResponse getTokenList(String clientIdentifier, String subject, int start, int end) throws AuthleteApiException {
        return this.callServiceGetApi(AUTH_TOKEN_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("clientIdentifier", clientIdentifier, "subject", subject, "start", start, "end", end), TokenListResponse.class);
    }

    @Override
    public RevocationResponse revocation(RevocationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_REVOCATION_API_PATH, request, RevocationResponse.class);
    }

    @Override
    public UserInfoResponse userinfo(UserInfoRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_USERINFO_API_PATH, request, UserInfoResponse.class);
    }

    @Override
    public UserInfoIssueResponse userinfoIssue(UserInfoIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_USERINFO_ISSUE_API_PATH, request, UserInfoIssueResponse.class);
    }

    @Override
    public IntrospectionResponse introspection(IntrospectionRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_INTROSPECTION_API_PATH, request, IntrospectionResponse.class);
    }

    @Override
    public StandardIntrospectionResponse standardIntrospection(StandardIntrospectionRequest request) throws AuthleteApiException {
        return this.callServicePostApi(AUTH_INTROSPECTION_STANDARD_API_PATH, request, StandardIntrospectionResponse.class);
    }

    @Override
    public Service createService(Service service) throws AuthleteApiException {
        return this.callServiceOwnerPostApi(SERVICE_CREATE_API_PATH, service, Service.class);
    }

    @Override
    public Service createServie(Service service) throws AuthleteApiException {
        return this.createService(service);
    }

    @Override
    public void deleteService(long apiKey) throws AuthleteApiException {
        this.callServiceOwnerDeleteApi(String.format(SERVICE_DELETE_API_PATH, apiKey));
    }

    @Override
    public Service getService(long apiKey) throws AuthleteApiException {
        return this.callServiceOwnerGetApi(String.format(SERVICE_GET_API_PATH, apiKey), Service.class);
    }

    @Override
    public ServiceListResponse getServiceList() throws AuthleteApiException {
        return this.callServiceOwnerGetApi(SERVICE_GET_LIST_API_PATH, ServiceListResponse.class);
    }

    @Override
    public ServiceListResponse getServiceList(int start, int end) throws AuthleteApiException {
        return this.callServiceOwnerGetApi(SERVICE_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("start", start, "end", end), ServiceListResponse.class);
    }

    @Override
    public Service updateService(Service service) throws AuthleteApiException {
        return this.callServiceOwnerPostApi(String.format(SERVICE_UPDATE_API_PATH, service.getApiKey()), service, Service.class);
    }

    @Override
    public String getServiceJwks() throws AuthleteApiException {
        return this.callServiceGetApi(SERVICE_JWKS_GET_API_PATH, String.class);
    }

    @Override
    public String getServiceJwks(boolean pretty, boolean includePrivateKeys) throws AuthleteApiException {
        return this.callServiceGetApi(SERVICE_JWKS_GET_API_PATH, AuthleteApiImpl.buildMap("pretty", pretty, "includePrivateKeys", includePrivateKeys), String.class);
    }

    @Override
    public String getServiceConfiguration() throws AuthleteApiException {
        return this.callServiceGetApi(SERVICE_CONFIGURATION_API_PATH, String.class);
    }

    @Override
    public String getServiceConfiguration(boolean pretty) throws AuthleteApiException {
        return this.callServiceGetApi(SERVICE_CONFIGURATION_API_PATH, AuthleteApiImpl.buildMap("pretty", pretty), String.class);
    }

    @Override
    public String getServiceConfiguration(ServiceConfigurationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(SERVICE_CONFIGURATION_API_PATH, request, String.class);
    }

    @Override
    public Client createClient(Client client) throws AuthleteApiException {
        return this.callServicePostApi(CLIENT_CREATE_API_PATH, client, Client.class);
    }

    @Override
    public ClientRegistrationResponse dynamicClientRegister(ClientRegistrationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(CLIENT_REGISTRATION_API_PATH, request, ClientRegistrationResponse.class);
    }

    @Override
    public ClientRegistrationResponse dynamicClientGet(ClientRegistrationRequest request) {
        return this.callServicePostApi(CLIENT_REGISTRATION_GET_API_PATH, request, ClientRegistrationResponse.class);
    }

    @Override
    public ClientRegistrationResponse dynamicClientUpdate(ClientRegistrationRequest request) {
        return this.callServicePostApi(CLIENT_REGISTRATION_UPDATE_API_PATH, request, ClientRegistrationResponse.class);
    }

    @Override
    public ClientRegistrationResponse dynamicClientDelete(ClientRegistrationRequest request) {
        return this.callServicePostApi(CLIENT_REGISTRATION_DELETE_API_PATH, request, ClientRegistrationResponse.class);
    }

    @Override
    public void deleteClient(long clientId) throws AuthleteApiException {
        this.deleteClient(String.valueOf(clientId));
    }

    @Override
    public void deleteClient(String clientId) throws AuthleteApiException {
        this.callServiceDeleteApi(String.format(CLIENT_DELETE_API_PATH, clientId));
    }

    @Override
    public Client getClient(long clientId) throws AuthleteApiException {
        return this.getClient(String.valueOf(clientId));
    }

    @Override
    public Client getClient(String clientId) throws AuthleteApiException {
        return this.callServiceGetApi(String.format(CLIENT_GET_API_PATH, clientId), Client.class);
    }

    @Override
    public ClientListResponse getClientList() throws AuthleteApiException {
        return this.callServiceGetApi(CLIENT_GET_LIST_API_PATH, ClientListResponse.class);
    }

    @Override
    public ClientListResponse getClientList(String developer) throws AuthleteApiException {
        return this.callServiceGetApi(CLIENT_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("developer", developer), ClientListResponse.class);
    }

    @Override
    public ClientListResponse getClientList(int start, int end) throws AuthleteApiException {
        return this.callServiceGetApi(CLIENT_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("start", start, "end", end), ClientListResponse.class);
    }

    @Override
    public ClientListResponse getClientList(String developer, int start, int end) throws AuthleteApiException {
        return this.callServiceGetApi(CLIENT_GET_LIST_API_PATH, AuthleteApiImpl.buildMap("developer", developer, "start", start, "end", end), ClientListResponse.class);
    }

    @Override
    public Client updateClient(Client client) throws AuthleteApiException {
        return this.callServicePostApi(String.format(CLIENT_UPDATE_API_PATH, client.getClientId()), client, Client.class);
    }

    @Override
    public String[] getRequestableScopes(long clientId) throws AuthleteApiException {
        RequestableScopes response = this.callServiceGetApi(String.format(REQUESTABLE_SCOPES_GET_API_PATH, clientId), RequestableScopes.class);
        return AuthleteApiImpl.extractRequestableScopes(response);
    }

    @Override
    public String[] setRequestableScopes(long clientId, String[] scopes) throws AuthleteApiException {
        RequestableScopes request = new RequestableScopes(scopes);
        RequestableScopes response = this.callServicePostApi(String.format(REQUESTABLE_SCOPES_UPDATE_API_PATH, clientId), request, RequestableScopes.class);
        return AuthleteApiImpl.extractRequestableScopes(response);
    }

    @Override
    public void deleteRequestableScopes(long clientId) throws AuthleteApiException {
        this.callServiceDeleteApi(String.format(REQUESTABLE_SCOPES_DELETE_API_PATH, clientId));
    }

    private static String[] extractRequestableScopes(RequestableScopes object) {
        if (object != null) {
            return object.getRequestableScopes();
        }
        return null;
    }

    @Override
    public GrantedScopesGetResponse getGrantedScopes(long clientId, String subject) {
        GrantedScopesRequest request = new GrantedScopesRequest(subject);
        return this.callServicePostApi(String.format(GRANTED_SCOPES_GET_API_PATH, clientId), request, GrantedScopesGetResponse.class);
    }

    @Override
    public void deleteGrantedScopes(long clientId, String subject) {
        GrantedScopesRequest request = new GrantedScopesRequest(subject);
        this.callServicePostApi(String.format(GRANTED_SCOPES_DELETE_API_PATH, clientId), request, ApiResponse.class);
    }

    @Override
    public void deleteClientAuthorization(long clientId, String subject) throws AuthleteApiException {
        ClientAuthorizationDeleteRequest request = new ClientAuthorizationDeleteRequest(subject);
        this.callServicePostApi(String.format(CLIENT_AUTHORIZATION_DELETE_API_PATH, clientId), request, ApiResponse.class);
    }

    @Override
    public AuthorizedClientListResponse getClientAuthorizationList(ClientAuthorizationGetListRequest request) throws AuthleteApiException {
        return this.callServicePostApi(CLIENT_AUTHORIZATION_GET_LIST_API_PATH, request, AuthorizedClientListResponse.class);
    }

    @Override
    public void updateClientAuthorization(long clientId, ClientAuthorizationUpdateRequest request) throws AuthleteApiException {
        this.callServicePostApi(String.format(CLIENT_AUTHORIZATION_UPDATE_API_PATH, clientId), request, ApiResponse.class);
    }

    @Override
    public ClientSecretRefreshResponse refreshClientSecret(long clientId) throws AuthleteApiException {
        return this.refreshClientSecret(String.valueOf(clientId));
    }

    @Override
    public ClientSecretRefreshResponse refreshClientSecret(String clientIdentifier) throws AuthleteApiException {
        return this.callServiceGetApi(String.format(CLIENT_SECRET_REFRESH_API_PATH, clientIdentifier), ClientSecretRefreshResponse.class);
    }

    @Override
    public ClientSecretUpdateResponse updateClientSecret(long clientId, String clientSecret) throws AuthleteApiException {
        return this.updateClientSecret(String.valueOf(clientId), clientSecret);
    }

    @Override
    public ClientSecretUpdateResponse updateClientSecret(String clientIdentifier, String clientSecret) throws AuthleteApiException {
        ClientSecretUpdateRequest request = new ClientSecretUpdateRequest().setClientSecret(clientSecret);
        return this.callServicePostApi(String.format(CLIENT_SECRET_UPDATE_API_PATH, clientIdentifier), request, ClientSecretUpdateResponse.class);
    }

    @Override
    public Settings getSettings() {
        return this.mSettings;
    }

    @Override
    public JoseVerifyResponse verifyJose(JoseVerifyRequest request) throws AuthleteApiException {
        return this.callServicePostApi(JOSE_VERIFY_API_PATH, request, JoseVerifyResponse.class);
    }

    @Override
    public BackchannelAuthenticationResponse backchannelAuthentication(BackchannelAuthenticationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(BC_AUTHENTICATION_API_PATH, request, BackchannelAuthenticationResponse.class);
    }

    @Override
    public BackchannelAuthenticationIssueResponse backchannelAuthenticationIssue(BackchannelAuthenticationIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(BC_AUTHENTICATION_ISSUE_API_PATH, request, BackchannelAuthenticationIssueResponse.class);
    }

    @Override
    public BackchannelAuthenticationFailResponse backchannelAuthenticationFail(BackchannelAuthenticationFailRequest request) throws AuthleteApiException {
        return this.callServicePostApi(BC_AUTHENTICATION_FAIL_API_PATH, request, BackchannelAuthenticationFailResponse.class);
    }

    @Override
    public BackchannelAuthenticationCompleteResponse backchannelAuthenticationComplete(BackchannelAuthenticationCompleteRequest request) throws AuthleteApiException {
        return this.callServicePostApi(BC_AUTHENTICATION_COMPLETE_API_PATH, request, BackchannelAuthenticationCompleteResponse.class);
    }

    @Override
    public DeviceAuthorizationResponse deviceAuthorization(DeviceAuthorizationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(DEVICE_AUTHORIZATION_API_PATH, request, DeviceAuthorizationResponse.class);
    }

    @Override
    public DeviceCompleteResponse deviceComplete(DeviceCompleteRequest request) throws AuthleteApiException {
        return this.callServicePostApi(DEVICE_COMPLETE_API_PATH, request, DeviceCompleteResponse.class);
    }

    @Override
    public DeviceVerificationResponse deviceVerification(DeviceVerificationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(DEVICE_VERIFICATION_API_PATH, request, DeviceVerificationResponse.class);
    }

    @Override
    public PushedAuthReqResponse pushAuthorizationRequest(PushedAuthReqRequest request) throws AuthleteApiException {
        return this.callServicePostApi(PUSHED_AUTH_REQ_API_PATH, request, PushedAuthReqResponse.class);
    }

    @Override
    public HskResponse hskCreate(HskCreateRequest request) throws AuthleteApiException {
        return this.callServicePostApi(HSK_CREATE_API_PATH, request, HskResponse.class);
    }

    @Override
    public HskResponse hskDelete(String handle) throws AuthleteApiException {
        return this.callServiceGetApi(String.format(HSK_DELETE_API_PATH, handle), HskResponse.class);
    }

    @Override
    public HskResponse hskGet(String handle) throws AuthleteApiException {
        return this.callServiceGetApi(String.format(HSK_GET_API_PATH, handle), HskResponse.class);
    }

    @Override
    public HskListResponse hskGetList() throws AuthleteApiException {
        return this.callServiceGetApi(HSK_GET_LIST_API_PATH, HskListResponse.class);
    }

    @Override
    public Map<String, String> echo(Map<String, String> parameters) throws AuthleteApiException {
        return this.callGetApi(null, ECHO_API_PATH, parameters, Map.class);
    }

    @Override
    public GMResponse gm(GMRequest request) throws AuthleteApiException {
        return this.callServicePostApi(GM_API_PATH, request, GMResponse.class);
    }

    @Override
    public void updateClientLockFlag(String clientIdentifier, boolean clientLocked) throws AuthleteApiException {
        ClientLockFlagUpdateRequest request = new ClientLockFlagUpdateRequest().setClientLocked(clientLocked);
        this.callServicePostApi(CLIENT_LOCK_FLAG_UPDATE_API_PATH, request, ApiResponse.class);
    }

    @Override
    public FederationConfigurationResponse federationConfiguration(FederationConfigurationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(FEDERATION_CONFIGURATION_API_PATH, request, FederationConfigurationResponse.class);
    }

    @Override
    public FederationRegistrationResponse federationRegistration(FederationRegistrationRequest request) throws AuthleteApiException {
        return this.callServicePostApi(FEDERATION_REGISTRATION_API_PATH, request, FederationRegistrationResponse.class);
    }

    @Override
    public CredentialIssuerMetadataResponse credentialIssuerMetadata(CredentialIssuerMetadataRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_METADATA_API_PATH, request, CredentialIssuerMetadataResponse.class);
    }

    @Override
    public CredentialIssuerJwksResponse credentialIssuerJwks(CredentialIssuerJwksRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_JWKS_API_PATH, request, CredentialIssuerJwksResponse.class);
    }

    @Override
    public CredentialOfferCreateResponse credentialOfferCreate(CredentialOfferCreateRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_OFFER_CREATE_API_PATH, request, CredentialOfferCreateResponse.class);
    }

    @Override
    public CredentialOfferInfoResponse credentialOfferInfo(CredentialOfferInfoRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_OFFER_INFO_API_PATH, request, CredentialOfferInfoResponse.class);
    }

    @Override
    public CredentialSingleParseResponse credentialSingleParse(CredentialSingleParseRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_SINGLE_PARSE_API_PATH, request, CredentialSingleParseResponse.class);
    }

    @Override
    public CredentialSingleIssueResponse credentialSingleIssue(CredentialSingleIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_SINGLE_ISSUE_API_PATH, request, CredentialSingleIssueResponse.class);
    }

    @Override
    public CredentialBatchParseResponse credentialBatchParse(CredentialBatchParseRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_BATCH_PARSE_API_PATH, request, CredentialBatchParseResponse.class);
    }

    @Override
    public CredentialBatchIssueResponse credentialBatchIssue(CredentialBatchIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_BATCH_ISSUE_API_PATH, request, CredentialBatchIssueResponse.class);
    }

    @Override
    public CredentialDeferredParseResponse credentialDeferredParse(CredentialDeferredParseRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_DEFERRED_PARSE_API_PATH, request, CredentialDeferredParseResponse.class);
    }

    @Override
    public CredentialDeferredIssueResponse credentialDeferredIssue(CredentialDeferredIssueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(VCI_DEFERRED_ISSUE_API_PATH, request, CredentialDeferredIssueResponse.class);
    }

    @Override
    public IDTokenReissueResponse idTokenReissue(IDTokenReissueRequest request) throws AuthleteApiException {
        return this.callServicePostApi(ID_TOKEN_REISSUE_API_PATH, request, IDTokenReissueResponse.class);
    }

    private static final class GrantedScopesRequest {
        private String subject;

        public GrantedScopesRequest(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }
    }

    private static final class RequestableScopes {
        private String[] requestableScopes;

        public RequestableScopes() {
        }

        public RequestableScopes(String[] requestableScopes) {
            this.requestableScopes = requestableScopes;
        }

        public String[] getRequestableScopes() {
            return this.requestableScopes;
        }

        public void setRequestableScopes(String[] requestableScopes) {
            this.requestableScopes = requestableScopes;
        }
    }

    private static enum HttpMethod {
        GET,
        POST,
        DELETE;

    }
}

