/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Claims;
import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import com.authlete.common.assurance.Verification;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class VerifiedClaims
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String VERIFICATION = "verification";
    private static final String CLAIMS = "claims";
    private static final Set<String> KEYS = new HashSet<String>();

    public Verification getVerification() {
        return (Verification)this.get(VERIFICATION);
    }

    public VerifiedClaims setVerification(Verification verification) {
        this.put(VERIFICATION, verification);
        return this;
    }

    public boolean containsVerification() {
        return this.containsKey(VERIFICATION);
    }

    public Verification removeVerification() {
        return (Verification)this.remove(VERIFICATION);
    }

    public Claims getClaims() {
        return (Claims)this.get(CLAIMS);
    }

    public VerifiedClaims setClaims(Claims claims) {
        this.put(CLAIMS, claims);
        return this;
    }

    public boolean containsClaims() {
        return this.containsKey(CLAIMS);
    }

    public Claims removeClaims() {
        return (Claims)this.remove(CLAIMS);
    }

    public VerifiedClaims addClaim(String name, Object value) {
        HashMap map = this.getClaims();
        if (map == null) {
            map = new HashMap();
            this.put(CLAIMS, map);
        }
        map.put(name, value);
        return this;
    }

    public static VerifiedClaims extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        VerifiedClaims instance = new VerifiedClaims();
        VerifiedClaims.fill(instance, object, key);
        return instance;
    }

    private static void fill(VerifiedClaims instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        VerifiedClaims.fillVerification(instance, map, key);
        VerifiedClaims.fillClaims(instance, map, key);
        Helper.ensureNoAdditionalProperties(map, key, KEYS);
    }

    private static void fillVerification(VerifiedClaims instance, Map<?, ?> map, String key) {
        Helper.ensureKey(map, VERIFICATION, key);
        Verification verification = Verification.extract(map, VERIFICATION);
        Helper.ensureNotNull(verification, VERIFICATION);
        instance.setVerification(verification);
    }

    private static void fillClaims(VerifiedClaims instance, Map<?, ?> map, String key) {
        Helper.ensureKey(map, CLAIMS, key);
        Claims claims = Claims.extract(map, CLAIMS);
        Helper.ensureNotNull(claims, CLAIMS);
        instance.setClaims(claims);
    }

    static {
        KEYS.add(VERIFICATION);
        KEYS.add(CLAIMS);
    }
}

