/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.IDDocumentConstraint;
import com.authlete.common.assurance.constraint.LeafConstraint;
import com.authlete.common.assurance.constraint.QESConstraint;
import com.authlete.common.assurance.constraint.UtilityBillConstraint;
import java.util.List;
import java.util.Map;

public class EvidenceConstraint
extends BaseConstraint {
    private static final String[] ID_DOCUMENT_TOP_LEVEL_PROPERTIES = new String[]{"method", "verifier", "time", "document"};
    private static final String[] QES_TOP_LEVEL_PROPERTIES = new String[]{"issuer", "serial_number", "created_at"};
    private static final String[] UTILITY_BILL_TOP_LEVEL_PROPERTIES = new String[]{"provider", "date"};
    private LeafConstraint type;

    public LeafConstraint getType() {
        return this.type;
    }

    public void setType(LeafConstraint constraint) {
        this.type = constraint;
    }

    public static EvidenceConstraint extract(List<?> list, int index, String key) throws ConstraintException {
        String label = String.format("%s[%d]", key, index);
        Object object = list.get(index);
        Helper.ensureNotNull(object, label);
        Map<?, ?> map = Helper.ensureMap(object, label);
        Class<? extends EvidenceConstraint> klass = EvidenceConstraint.guess(map, key, index);
        if (klass == IDDocumentConstraint.class) {
            return IDDocumentConstraint.extract(map);
        }
        if (klass == QESConstraint.class) {
            return QESConstraint.extract(map);
        }
        if (klass == UtilityBillConstraint.class) {
            return UtilityBillConstraint.extract(map);
        }
        return null;
    }

    private static Class<? extends EvidenceConstraint> guess(Map<?, ?> map, String key, int index) {
        Class<? extends EvidenceConstraint> klass = EvidenceConstraint.guessByType(map, key, index);
        if (klass != null) {
            return klass;
        }
        if (EvidenceConstraint.containsAny(map, ID_DOCUMENT_TOP_LEVEL_PROPERTIES)) {
            return IDDocumentConstraint.class;
        }
        if (EvidenceConstraint.containsAny(map, QES_TOP_LEVEL_PROPERTIES)) {
            return QESConstraint.class;
        }
        if (EvidenceConstraint.containsAny(map, UTILITY_BILL_TOP_LEVEL_PROPERTIES)) {
            return UtilityBillConstraint.class;
        }
        throw Helper.exception("'%s[%d]' is not a known evidence.", key, index);
    }

    private static Class<? extends EvidenceConstraint> guessByType(Map<?, ?> map, String key, int index) {
        LeafConstraint type = LeafConstraint.extract(map, "type");
        if (!type.exists()) {
            return null;
        }
        String value = type.getValue();
        if (value == null) {
            return null;
        }
        if (value.equals("id_document")) {
            return IDDocumentConstraint.class;
        }
        if (value.equals("qes")) {
            return QESConstraint.class;
        }
        if (value.equals("utility_bill")) {
            return UtilityBillConstraint.class;
        }
        throw Helper.exception("The type of '%s[%d]' is unknown.", key, index);
    }

    private static boolean containsAny(Map<?, ?> map, String[] names) {
        for (String name : names) {
            if (!map.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    static void fill(EvidenceConstraint instance, Map<?, ?> map) {
        instance.type = LeafConstraint.extract(map, "type");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        EvidenceConstraint.addIfAvailable(map, "type", this.type);
        return map;
    }
}

