/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.CredentialIssuerMetadata;
import com.authlete.common.dto.Hsk;
import com.authlete.common.dto.NamedUri;
import com.authlete.common.dto.Pair;
import com.authlete.common.dto.Scope;
import com.authlete.common.dto.SnsCredentials;
import com.authlete.common.dto.TrustAnchor;
import com.authlete.common.types.AttachmentType;
import com.authlete.common.types.ClaimType;
import com.authlete.common.types.ClientAuthMethod;
import com.authlete.common.types.ClientRegistrationType;
import com.authlete.common.types.DeliveryMode;
import com.authlete.common.types.Display;
import com.authlete.common.types.GrantType;
import com.authlete.common.types.JWEAlg;
import com.authlete.common.types.JWEEnc;
import com.authlete.common.types.JWSAlg;
import com.authlete.common.types.Prompt;
import com.authlete.common.types.ResponseType;
import com.authlete.common.types.ServiceProfile;
import com.authlete.common.types.Sns;
import com.authlete.common.types.UserCodeCharset;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.TreeSet;

public class Service
implements Serializable {
    private static final long serialVersionUID = 75L;
    private int number;
    private int serviceOwnerNumber;
    private String serviceName;
    private long apiKey;
    private String apiSecret;
    private URI issuer;
    private URI authorizationEndpoint;
    private URI tokenEndpoint;
    private URI revocationEndpoint;
    private ClientAuthMethod[] supportedRevocationAuthMethods;
    private URI userInfoEndpoint;
    private URI jwksUri;
    private String jwks;
    private URI registrationEndpoint;
    private URI registrationManagementEndpoint;
    private Scope[] supportedScopes;
    private ResponseType[] supportedResponseTypes;
    private GrantType[] supportedGrantTypes;
    private String[] supportedAcrs;
    private ClientAuthMethod[] supportedTokenAuthMethods;
    private Display[] supportedDisplays;
    private ClaimType[] supportedClaimTypes;
    private String[] supportedClaims;
    private URI serviceDocumentation;
    private String[] supportedClaimLocales;
    private String[] supportedUiLocales;
    private URI policyUri;
    private URI tosUri;
    private URI authenticationCallbackEndpoint;
    private String authenticationCallbackApiKey;
    private String authenticationCallbackApiSecret;
    private Sns[] supportedSnses;
    private SnsCredentials[] snsCredentials;
    private long createdAt;
    private long modifiedAt;
    private URI developerAuthenticationCallbackEndpoint;
    private String developerAuthenticationCallbackApiKey;
    private String developerAuthenticationCallbackApiSecret;
    private Sns[] supportedDeveloperSnses;
    private SnsCredentials[] developerSnsCredentials;
    private int clientsPerDeveloper;
    private boolean directAuthorizationEndpointEnabled;
    private boolean directTokenEndpointEnabled;
    private boolean directRevocationEndpointEnabled;
    private boolean directUserInfoEndpointEnabled;
    private boolean directJwksEndpointEnabled;
    private boolean directIntrospectionEndpointEnabled;
    private boolean singleAccessTokenPerSubject;
    private boolean pkceRequired;
    private boolean pkceS256Required;
    private boolean refreshTokenKept;
    private boolean refreshTokenDurationKept;
    private boolean refreshTokenDurationReset;
    private boolean errorDescriptionOmitted;
    private boolean errorUriOmitted;
    private boolean clientIdAliasEnabled;
    private ServiceProfile[] supportedServiceProfiles;
    private boolean tlsClientCertificateBoundAccessTokens;
    private URI introspectionEndpoint;
    private ClientAuthMethod[] supportedIntrospectionAuthMethods;
    private boolean mutualTlsValidatePkiCertChain;
    private String[] trustedRootCertificates;
    private boolean dynamicRegistrationSupported;
    private URI endSessionEndpoint;
    private String description;
    private String accessTokenType;
    private JWSAlg accessTokenSignAlg;
    private long accessTokenDuration;
    private long refreshTokenDuration;
    private long idTokenDuration;
    private long authorizationResponseDuration;
    private long pushedAuthReqDuration;
    private Pair[] metadata;
    private String accessTokenSignatureKeyId;
    private String authorizationSignatureKeyId;
    private String idTokenSignatureKeyId;
    private String userInfoSignatureKeyId;
    private DeliveryMode[] supportedBackchannelTokenDeliveryModes;
    private URI backchannelAuthenticationEndpoint;
    private boolean backchannelUserCodeParameterSupported;
    private int backchannelAuthReqIdDuration;
    private int backchannelPollingInterval;
    private boolean backchannelBindingMessageRequiredInFapi;
    private int allowableClockSkew;
    private URI deviceAuthorizationEndpoint;
    private URI deviceVerificationUri;
    private URI deviceVerificationUriComplete;
    private int deviceFlowCodeDuration;
    private int deviceFlowPollingInterval;
    private UserCodeCharset userCodeCharset;
    private int userCodeLength;
    private URI pushedAuthReqEndpoint;
    private NamedUri[] mtlsEndpointAliases;
    private String[] supportedAuthorizationDetailsTypes;
    private String[] supportedTrustFrameworks;
    private String[] supportedEvidence;
    @Deprecated
    private String[] supportedIdentityDocuments;
    private String[] supportedDocuments;
    @Deprecated
    private String[] supportedVerificationMethods;
    private String[] supportedDocumentsMethods;
    @Deprecated
    private String[] supportedDocumentsValidationMethods;
    @Deprecated
    private String[] supportedDocumentsVerificationMethods;
    private String[] supportedDocumentsCheckMethods;
    private String[] supportedElectronicRecords;
    private String[] supportedVerifiedClaims;
    private AttachmentType[] supportedAttachments;
    private String[] supportedDigestAlgorithms;
    private boolean missingClientIdAllowed;
    private boolean parRequired;
    private boolean requestObjectRequired;
    private boolean traditionalRequestObjectProcessingApplied;
    private boolean claimShortcutRestrictive;
    private boolean scopeRequired;
    private boolean nbfOptional;
    private boolean issSuppressed;
    private Pair[] attributes;
    private String[] supportedCustomClientMetadata;
    private boolean tokenExpirationLinked;
    private boolean frontChannelRequestObjectEncryptionRequired;
    private boolean requestObjectEncryptionAlgMatchRequired;
    private boolean requestObjectEncryptionEncMatchRequired;
    private boolean hsmEnabled;
    private Hsk[] hsks;
    private URI grantManagementEndpoint;
    private boolean grantManagementActionRequired;
    private boolean unauthorizedOnClientConfigSupported;
    private boolean dcrScopeUsedAsRequestable;
    private String predefinedTransformedClaims;
    private boolean loopbackRedirectionUriVariable;
    private boolean requestObjectAudienceChecked;
    private boolean accessTokenForExternalAttachmentEmbedded;
    private boolean refreshTokenIdempotent;
    private boolean federationEnabled;
    private String organizationName;
    private URI[] authorityHints;
    private TrustAnchor[] trustAnchors;
    private String federationJwks;
    private String federationSignatureKeyId;
    private long federationConfigurationDuration;
    private URI signedJwksUri;
    private URI federationRegistrationEndpoint;
    private ClientRegistrationType[] supportedClientRegistrationTypes;
    private boolean tokenExchangeByIdentifiableClientsOnly;
    private boolean tokenExchangeByConfidentialClientsOnly;
    private boolean tokenExchangeByPermittedClientsOnly;
    private boolean tokenExchangeEncryptedJwtRejected;
    private boolean tokenExchangeUnsignedJwtRejected;
    private boolean jwtGrantByIdentifiableClientsOnly;
    private boolean jwtGrantEncryptedJwtRejected;
    private boolean jwtGrantUnsignedJwtRejected;
    private boolean dcrDuplicateSoftwareIdBlocked;
    private String resourceSignatureKeyId;
    private boolean rsResponseSigned;
    private boolean openidDroppedOnRefreshWithoutOfflineAccess;
    private boolean verifiableCredentialsEnabled;
    private CredentialIssuerMetadata credentialIssuerMetadata;
    private long credentialOfferDuration;
    private int userPinLength;
    private String idTokenAudType;
    private Prompt[] supportedPromptValues;
    private String verifiedClaimsValidationSchemaSet;
    private boolean preAuthorizedGrantAnonymousAccessSupported;
    private long cNonceDuration;
    private long credentialTransactionDuration;
    private long credentialDuration;
    private String credentialJwks;
    private boolean idTokenReissuable;
    private JWSAlg[] supportedIntrospectionSignAlgs;
    private JWEAlg[] supportedIntrospectionEncryptionAlgs;
    private JWEEnc[] supportedIntrospectionEncryptionEncs;
    private String introspectionSignatureKeyId;

    public int getNumber() {
        return this.number;
    }

    public Service setNumber(int number) {
        this.number = number;
        return this;
    }

    public int getServiceOwnerNumber() {
        return this.serviceOwnerNumber;
    }

    public Service setServiceOwnerNumber(int serviceOwnerNumber) {
        this.serviceOwnerNumber = serviceOwnerNumber;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Service setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public long getApiKey() {
        return this.apiKey;
    }

    public Service setApiKey(long apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public Service setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public Service setIssuer(URI issuer) {
        this.issuer = issuer;
        return this;
    }

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public Service setAuthorizationEndpoint(URI endpoint) {
        this.authorizationEndpoint = endpoint;
        return this;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Service setTokenEndpoint(URI endpoint) {
        this.tokenEndpoint = endpoint;
        return this;
    }

    public URI getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public ClientAuthMethod[] getSupportedRevocationAuthMethods() {
        return this.supportedRevocationAuthMethods;
    }

    public Service setSupportedRevocationAuthMethods(ClientAuthMethod[] methods) {
        this.supportedRevocationAuthMethods = methods;
        return this;
    }

    public Service setRevocationEndpoint(URI endpoint) {
        this.revocationEndpoint = endpoint;
        return this;
    }

    public URI getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public Service setUserInfoEndpoint(URI endpoint) {
        this.userInfoEndpoint = endpoint;
        return this;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public Service setJwksUri(URI uri) {
        this.jwksUri = uri;
        return this;
    }

    public String getJwks() {
        return this.jwks;
    }

    public Service setJwks(String jwks) {
        this.jwks = jwks;
        return this;
    }

    public URI getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public Service setRegistrationEndpoint(URI endpoint) {
        this.registrationEndpoint = endpoint;
        return this;
    }

    public URI getRegistrationManagementEndpoint() {
        return this.registrationManagementEndpoint;
    }

    public Service setRegistrationManagementEndpoint(URI endpoint) {
        this.registrationManagementEndpoint = endpoint;
        return this;
    }

    public Scope[] getSupportedScopes() {
        return this.supportedScopes;
    }

    public Service setSupportedScopes(Scope[] supportedScopes) {
        this.supportedScopes = supportedScopes;
        return this;
    }

    public ResponseType[] getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public Service setSupportedResponseTypes(ResponseType[] responseTypes) {
        this.supportedResponseTypes = responseTypes;
        return this;
    }

    public GrantType[] getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public Service setSupportedGrantTypes(GrantType[] grantTypes) {
        this.supportedGrantTypes = grantTypes;
        return this;
    }

    public String[] getSupportedAcrs() {
        return this.supportedAcrs;
    }

    public Service setSupportedAcrs(String[] acrs) {
        this.supportedAcrs = acrs;
        return this;
    }

    public ClientAuthMethod[] getSupportedTokenAuthMethods() {
        return this.supportedTokenAuthMethods;
    }

    public Service setSupportedTokenAuthMethods(ClientAuthMethod[] methods) {
        this.supportedTokenAuthMethods = methods;
        return this;
    }

    public Display[] getSupportedDisplays() {
        return this.supportedDisplays;
    }

    public Service setSupportedDisplays(Display[] displays) {
        this.supportedDisplays = displays;
        return this;
    }

    public ClaimType[] getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public Service setSupportedClaimTypes(ClaimType[] claimTypes) {
        this.supportedClaimTypes = claimTypes;
        return this;
    }

    public String[] getSupportedClaims() {
        return this.supportedClaims;
    }

    public Service setSupportedClaims(String[] supportedClaims) {
        this.supportedClaims = supportedClaims;
        return this;
    }

    public URI getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public Service setServiceDocumentation(URI uri) {
        this.serviceDocumentation = uri;
        return this;
    }

    public String[] getSupportedClaimLocales() {
        return this.supportedClaimLocales;
    }

    public Service setSupportedClaimLocales(String[] supportedClaimLocales) {
        this.supportedClaimLocales = supportedClaimLocales;
        return this;
    }

    public String[] getSupportedUiLocales() {
        return this.supportedUiLocales;
    }

    public Service setSupportedUiLocales(String[] supportedUiLocales) {
        this.supportedUiLocales = supportedUiLocales;
        return this;
    }

    public URI getPolicyUri() {
        return this.policyUri;
    }

    public Service setPolicyUri(URI uri) {
        this.policyUri = uri;
        return this;
    }

    public URI getTosUri() {
        return this.tosUri;
    }

    public Service setTosUri(URI uri) {
        this.tosUri = uri;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Service setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public Service setAccessTokenType(String type) {
        this.accessTokenType = type;
        return this;
    }

    public JWSAlg getAccessTokenSignAlg() {
        return this.accessTokenSignAlg;
    }

    public Service setAccessTokenSignAlg(JWSAlg alg) {
        this.accessTokenSignAlg = alg;
        return this;
    }

    public long getAccessTokenDuration() {
        return this.accessTokenDuration;
    }

    public Service setAccessTokenDuration(long duration) {
        this.accessTokenDuration = duration;
        return this;
    }

    public long getRefreshTokenDuration() {
        return this.refreshTokenDuration;
    }

    public Service setRefreshTokenDuration(long duration) {
        this.refreshTokenDuration = duration;
        return this;
    }

    public long getIdTokenDuration() {
        return this.idTokenDuration;
    }

    public Service setIdTokenDuration(long duration) {
        this.idTokenDuration = duration;
        return this;
    }

    public long getAuthorizationResponseDuration() {
        return this.authorizationResponseDuration;
    }

    public Service setAuthorizationResponseDuration(long duration) {
        this.authorizationResponseDuration = duration;
        return this;
    }

    public long getPushedAuthReqDuration() {
        return this.pushedAuthReqDuration;
    }

    public Service setPushedAuthReqDuration(long duration) {
        this.pushedAuthReqDuration = duration;
        return this;
    }

    public URI getAuthenticationCallbackEndpoint() {
        return this.authenticationCallbackEndpoint;
    }

    public Service setAuthenticationCallbackEndpoint(URI endpoint) {
        this.authenticationCallbackEndpoint = endpoint;
        return this;
    }

    public String getAuthenticationCallbackApiKey() {
        return this.authenticationCallbackApiKey;
    }

    public Service setAuthenticationCallbackApiKey(String apiKey) {
        this.authenticationCallbackApiKey = apiKey;
        return this;
    }

    public String getAuthenticationCallbackApiSecret() {
        return this.authenticationCallbackApiSecret;
    }

    public Service setAuthenticationCallbackApiSecret(String apiSecret) {
        this.authenticationCallbackApiSecret = apiSecret;
        return this;
    }

    public Sns[] getSupportedSnses() {
        return this.supportedSnses;
    }

    public Service setSupportedSnses(Sns[] supportedSnses) {
        this.supportedSnses = supportedSnses;
        return this;
    }

    public SnsCredentials[] getSnsCredentials() {
        return this.snsCredentials;
    }

    public Service setSnsCredentials(SnsCredentials[] snsCredentials) {
        this.snsCredentials = snsCredentials;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Service setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public Service setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public Pair[] getMetadata() {
        return this.metadata;
    }

    public Service setMetadata(Pair[] metadata) {
        this.metadata = metadata;
        return this;
    }

    public URI getDeveloperAuthenticationCallbackEndpoint() {
        return this.developerAuthenticationCallbackEndpoint;
    }

    public Service setDeveloperAuthenticationCallbackEndpoint(URI endpoint) {
        this.developerAuthenticationCallbackEndpoint = endpoint;
        return this;
    }

    public String getDeveloperAuthenticationCallbackApiKey() {
        return this.developerAuthenticationCallbackApiKey;
    }

    public Service setDeveloperAuthenticationCallbackApiKey(String apiKey) {
        this.developerAuthenticationCallbackApiKey = apiKey;
        return this;
    }

    public String getDeveloperAuthenticationCallbackApiSecret() {
        return this.developerAuthenticationCallbackApiSecret;
    }

    public Service setDeveloperAuthenticationCallbackApiSecret(String apiSecret) {
        this.developerAuthenticationCallbackApiSecret = apiSecret;
        return this;
    }

    public Sns[] getSupportedDeveloperSnses() {
        return this.supportedDeveloperSnses;
    }

    public Service setSupportedDeveloperSnses(Sns[] supportedSnses) {
        this.supportedDeveloperSnses = supportedSnses;
        return this;
    }

    public SnsCredentials[] getDeveloperSnsCredentials() {
        return this.developerSnsCredentials;
    }

    public Service setDeveloperSnsCredentials(SnsCredentials[] snsCredentials) {
        this.developerSnsCredentials = snsCredentials;
        return this;
    }

    public int getClientsPerDeveloper() {
        return this.clientsPerDeveloper;
    }

    public Service setClientsPerDeveloper(int count) {
        this.clientsPerDeveloper = count;
        return this;
    }

    public boolean isDirectAuthorizationEndpointEnabled() {
        return this.directAuthorizationEndpointEnabled;
    }

    public Service setDirectAuthorizationEndpointEnabled(boolean enabled) {
        this.directAuthorizationEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectTokenEndpointEnabled() {
        return this.directTokenEndpointEnabled;
    }

    public Service setDirectTokenEndpointEnabled(boolean enabled) {
        this.directTokenEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectRevocationEndpointEnabled() {
        return this.directRevocationEndpointEnabled;
    }

    public Service setDirectRevocationEndpointEnabled(boolean enabled) {
        this.directRevocationEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectUserInfoEndpointEnabled() {
        return this.directUserInfoEndpointEnabled;
    }

    public Service setDirectUserInfoEndpointEnabled(boolean enabled) {
        this.directUserInfoEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectJwksEndpointEnabled() {
        return this.directJwksEndpointEnabled;
    }

    public Service setDirectJwksEndpointEnabled(boolean enabled) {
        this.directJwksEndpointEnabled = enabled;
        return this;
    }

    public boolean isDirectIntrospectionEndpointEnabled() {
        return this.directIntrospectionEndpointEnabled;
    }

    public Service setDirectIntrospectionEndpointEnabled(boolean enabled) {
        this.directIntrospectionEndpointEnabled = enabled;
        return this;
    }

    public boolean isSingleAccessTokenPerSubject() {
        return this.singleAccessTokenPerSubject;
    }

    public Service setSingleAccessTokenPerSubject(boolean single) {
        this.singleAccessTokenPerSubject = single;
        return this;
    }

    public boolean isPkceRequired() {
        return this.pkceRequired;
    }

    public Service setPkceRequired(boolean required) {
        this.pkceRequired = required;
        return this;
    }

    public boolean isPkceS256Required() {
        return this.pkceS256Required;
    }

    public Service setPkceS256Required(boolean required) {
        this.pkceS256Required = required;
        return this;
    }

    public boolean isRefreshTokenKept() {
        return this.refreshTokenKept;
    }

    public Service setRefreshTokenKept(boolean kept) {
        this.refreshTokenKept = kept;
        return this;
    }

    public boolean isRefreshTokenDurationKept() {
        return this.refreshTokenDurationKept;
    }

    public Service setRefreshTokenDurationKept(boolean kept) {
        this.refreshTokenDurationKept = kept;
        return this;
    }

    public boolean isRefreshTokenDurationReset() {
        return this.refreshTokenDurationReset;
    }

    public Service setRefreshTokenDurationReset(boolean reset) {
        this.refreshTokenDurationReset = reset;
        return this;
    }

    public boolean isErrorDescriptionOmitted() {
        return this.errorDescriptionOmitted;
    }

    public Service setErrorDescriptionOmitted(boolean omitted) {
        this.errorDescriptionOmitted = omitted;
        return this;
    }

    public boolean isErrorUriOmitted() {
        return this.errorUriOmitted;
    }

    public Service setErrorUriOmitted(boolean omitted) {
        this.errorUriOmitted = omitted;
        return this;
    }

    public boolean isClientIdAliasEnabled() {
        return this.clientIdAliasEnabled;
    }

    public Service setClientIdAliasEnabled(boolean enabled) {
        this.clientIdAliasEnabled = enabled;
        return this;
    }

    public String getAccessTokenSignatureKeyId() {
        return this.accessTokenSignatureKeyId;
    }

    public Service setAccessTokenSignatureKeyId(String keyId) {
        this.accessTokenSignatureKeyId = keyId;
        return this;
    }

    public String getAuthorizationSignatureKeyId() {
        return this.authorizationSignatureKeyId;
    }

    public Service setAuthorizationSignatureKeyId(String keyId) {
        this.authorizationSignatureKeyId = keyId;
        return this;
    }

    public String getIdTokenSignatureKeyId() {
        return this.idTokenSignatureKeyId;
    }

    public Service setIdTokenSignatureKeyId(String keyId) {
        this.idTokenSignatureKeyId = keyId;
        return this;
    }

    public String getUserInfoSignatureKeyId() {
        return this.userInfoSignatureKeyId;
    }

    public Service setUserInfoSignatureKeyId(String keyId) {
        this.userInfoSignatureKeyId = keyId;
        return this;
    }

    public ServiceProfile[] getSupportedServiceProfiles() {
        return this.supportedServiceProfiles;
    }

    public Service setSupportedServiceProfiles(ServiceProfile[] profiles) {
        this.supportedServiceProfiles = profiles;
        return this;
    }

    public Service setSupportedServiceProfiles(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            this.supportedServiceProfiles = null;
            return this;
        }
        TreeSet<ServiceProfile> set = new TreeSet<ServiceProfile>();
        for (ServiceProfile profile : profiles) {
            if (profile == null) continue;
            set.add(profile);
        }
        int size = set.size();
        if (size == 0) {
            this.supportedServiceProfiles = null;
            return this;
        }
        ServiceProfile[] array = new ServiceProfile[size];
        this.supportedServiceProfiles = set.toArray(array);
        return this;
    }

    public boolean supports(ServiceProfile profile) {
        if (profile == null) {
            return false;
        }
        if (this.supportedServiceProfiles == null) {
            return false;
        }
        for (ServiceProfile supportedProfile : this.supportedServiceProfiles) {
            if (supportedProfile != profile) continue;
            return true;
        }
        return false;
    }

    public boolean supportsAll(ServiceProfile ... profiles) {
        if (profiles == null) {
            return true;
        }
        for (ServiceProfile profile : profiles) {
            if (this.supports(profile)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsAll(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            return true;
        }
        for (ServiceProfile profile : profiles) {
            if (this.supports(profile)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsAny(ServiceProfile ... profiles) {
        if (profiles == null) {
            return false;
        }
        for (ServiceProfile profile : profiles) {
            if (!this.supports(profile)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsAny(Iterable<ServiceProfile> profiles) {
        if (profiles == null) {
            return false;
        }
        for (ServiceProfile profile : profiles) {
            if (!this.supports(profile)) continue;
            return true;
        }
        return false;
    }

    public boolean isTlsClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public Service setTlsClientCertificateBoundAccessTokens(boolean enabled) {
        this.tlsClientCertificateBoundAccessTokens = enabled;
        return this;
    }

    public URI getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public Service setIntrospectionEndpoint(URI endpoint) {
        this.introspectionEndpoint = endpoint;
        return this;
    }

    public ClientAuthMethod[] getSupportedIntrospectionAuthMethods() {
        return this.supportedIntrospectionAuthMethods;
    }

    public Service setSupportedIntrospectionAuthMethods(ClientAuthMethod[] methods) {
        this.supportedIntrospectionAuthMethods = methods;
        return this;
    }

    public boolean isMutualTlsValidatePkiCertChain() {
        return this.mutualTlsValidatePkiCertChain;
    }

    public Service setMutualTlsValidatePkiCertChain(boolean mutualTlsValidatePkiCertChain) {
        this.mutualTlsValidatePkiCertChain = mutualTlsValidatePkiCertChain;
        return this;
    }

    public String[] getTrustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    public Service setTrustedRootCertificates(String[] trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    public DeliveryMode[] getSupportedBackchannelTokenDeliveryModes() {
        return this.supportedBackchannelTokenDeliveryModes;
    }

    public Service setSupportedBackchannelTokenDeliveryModes(DeliveryMode[] modes) {
        this.supportedBackchannelTokenDeliveryModes = modes;
        return this;
    }

    public URI getBackchannelAuthenticationEndpoint() {
        return this.backchannelAuthenticationEndpoint;
    }

    public Service setBackchannelAuthenticationEndpoint(URI endpoint) {
        this.backchannelAuthenticationEndpoint = endpoint;
        return this;
    }

    public boolean isBackchannelUserCodeParameterSupported() {
        return this.backchannelUserCodeParameterSupported;
    }

    public Service setBackchannelUserCodeParameterSupported(boolean supported) {
        this.backchannelUserCodeParameterSupported = supported;
        return this;
    }

    public int getBackchannelAuthReqIdDuration() {
        return this.backchannelAuthReqIdDuration;
    }

    public Service setBackchannelAuthReqIdDuration(int duration) {
        this.backchannelAuthReqIdDuration = duration;
        return this;
    }

    public int getBackchannelPollingInterval() {
        return this.backchannelPollingInterval;
    }

    public Service setBackchannelPollingInterval(int interval) {
        this.backchannelPollingInterval = interval;
        return this;
    }

    public boolean isBackchannelBindingMessageRequiredInFapi() {
        return this.backchannelBindingMessageRequiredInFapi;
    }

    public Service setBackchannelBindingMessageRequiredInFapi(boolean required) {
        this.backchannelBindingMessageRequiredInFapi = required;
        return this;
    }

    public int getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public Service setAllowableClockSkew(int seconds) {
        this.allowableClockSkew = seconds;
        return this;
    }

    public boolean isDynamicRegistrationSupported() {
        return this.dynamicRegistrationSupported;
    }

    public Service setDynamicRegistrationSupported(boolean enabled) {
        this.dynamicRegistrationSupported = enabled;
        return this;
    }

    public URI getDeviceAuthorizationEndpoint() {
        return this.deviceAuthorizationEndpoint;
    }

    public Service setDeviceAuthorizationEndpoint(URI endpoint) {
        this.deviceAuthorizationEndpoint = endpoint;
        return this;
    }

    public URI getDeviceVerificationUri() {
        return this.deviceVerificationUri;
    }

    public Service setDeviceVerificationUri(URI uri) {
        this.deviceVerificationUri = uri;
        return this;
    }

    public URI getDeviceVerificationUriComplete() {
        return this.deviceVerificationUriComplete;
    }

    public Service setDeviceVerificationUriComplete(URI uri) {
        this.deviceVerificationUriComplete = uri;
        return this;
    }

    public int getDeviceFlowCodeDuration() {
        return this.deviceFlowCodeDuration;
    }

    public Service setDeviceFlowCodeDuration(int duration) {
        this.deviceFlowCodeDuration = duration;
        return this;
    }

    public int getDeviceFlowPollingInterval() {
        return this.deviceFlowPollingInterval;
    }

    public Service setDeviceFlowPollingInterval(int interval) {
        this.deviceFlowPollingInterval = interval;
        return this;
    }

    public UserCodeCharset getUserCodeCharset() {
        return this.userCodeCharset;
    }

    public Service setUserCodeCharset(UserCodeCharset charset) {
        this.userCodeCharset = charset;
        return this;
    }

    public int getUserCodeLength() {
        return this.userCodeLength;
    }

    public Service setUserCodeLength(int length) {
        this.userCodeLength = length;
        return this;
    }

    public URI getPushedAuthReqEndpoint() {
        return this.pushedAuthReqEndpoint;
    }

    public Service setPushedAuthReqEndpoint(URI endpoint) {
        this.pushedAuthReqEndpoint = endpoint;
        return this;
    }

    public NamedUri[] getMtlsEndpointAliases() {
        return this.mtlsEndpointAliases;
    }

    public Service setMtlsEndpointAliases(NamedUri[] aliases) {
        this.mtlsEndpointAliases = aliases;
        return this;
    }

    public String[] getSupportedAuthorizationDetailsTypes() {
        return this.supportedAuthorizationDetailsTypes;
    }

    public Service setSupportedAuthorizationDetailsTypes(String[] types) {
        this.supportedAuthorizationDetailsTypes = types;
        return this;
    }

    public String[] getSupportedTrustFrameworks() {
        return this.supportedTrustFrameworks;
    }

    public Service setSupportedTrustFrameworks(String[] frameworks) {
        this.supportedTrustFrameworks = frameworks;
        return this;
    }

    public String[] getSupportedEvidence() {
        return this.supportedEvidence;
    }

    public Service setSupportedEvidence(String[] evidence) {
        this.supportedEvidence = evidence;
        return this;
    }

    @Deprecated
    public String[] getSupportedIdentityDocuments() {
        return this.supportedIdentityDocuments;
    }

    @Deprecated
    public Service setSupportedIdentityDocuments(String[] documents) {
        this.supportedIdentityDocuments = documents;
        return this;
    }

    public String[] getSupportedDocuments() {
        return this.supportedDocuments;
    }

    public Service setSupportedDocuments(String[] documents) {
        this.supportedDocuments = documents;
        return this;
    }

    @Deprecated
    public String[] getSupportedVerificationMethods() {
        return this.supportedVerificationMethods;
    }

    @Deprecated
    public Service setSupportedVerificationMethods(String[] methods) {
        this.supportedVerificationMethods = methods;
        return this;
    }

    public String[] getSupportedDocumentsMethods() {
        return this.supportedDocumentsMethods;
    }

    public Service setSupportedDocumentsMethods(String[] methods) {
        this.supportedDocumentsMethods = methods;
        return this;
    }

    @Deprecated
    public String[] getSupportedDocumentsValidationMethods() {
        return this.supportedDocumentsValidationMethods;
    }

    @Deprecated
    public Service setSupportedDocumentsValidationMethods(String[] methods) {
        this.supportedDocumentsValidationMethods = methods;
        return this;
    }

    @Deprecated
    public String[] getSupportedDocumentsVerificationMethods() {
        return this.supportedDocumentsVerificationMethods;
    }

    @Deprecated
    public Service setSupportedDocumentsVerificationMethods(String[] methods) {
        this.supportedDocumentsVerificationMethods = methods;
        return this;
    }

    public String[] getSupportedDocumentsCheckMethods() {
        return this.supportedDocumentsCheckMethods;
    }

    public Service setSupportedDocumentsCheckMethods(String[] methods) {
        this.supportedDocumentsCheckMethods = methods;
        return this;
    }

    public String[] getSupportedElectronicRecords() {
        return this.supportedElectronicRecords;
    }

    public Service setSupportedElectronicRecords(String[] records) {
        this.supportedElectronicRecords = records;
        return this;
    }

    public String[] getSupportedVerifiedClaims() {
        return this.supportedVerifiedClaims;
    }

    public Service setSupportedVerifiedClaims(String[] claims) {
        this.supportedVerifiedClaims = claims;
        return this;
    }

    public AttachmentType[] getSupportedAttachments() {
        return this.supportedAttachments;
    }

    public Service setSupportedAttachments(AttachmentType[] types) {
        this.supportedAttachments = types;
        return this;
    }

    public String[] getSupportedDigestAlgorithms() {
        return this.supportedDigestAlgorithms;
    }

    public Service setSupportedDigestAlgorithms(String[] algorithms) {
        this.supportedDigestAlgorithms = algorithms;
        return this;
    }

    public boolean isMissingClientIdAllowed() {
        return this.missingClientIdAllowed;
    }

    public Service setMissingClientIdAllowed(boolean allowed) {
        this.missingClientIdAllowed = allowed;
        return this;
    }

    public URI getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public Service setEndSessionEndpoint(URI endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    public boolean isParRequired() {
        return this.parRequired;
    }

    public Service setParRequired(boolean required) {
        this.parRequired = required;
        return this;
    }

    public boolean isRequestObjectRequired() {
        return this.requestObjectRequired;
    }

    public Service setRequestObjectRequired(boolean required) {
        this.requestObjectRequired = required;
        return this;
    }

    public boolean isTraditionalRequestObjectProcessingApplied() {
        return this.traditionalRequestObjectProcessingApplied;
    }

    public Service setTraditionalRequestObjectProcessingApplied(boolean applied) {
        this.traditionalRequestObjectProcessingApplied = applied;
        return this;
    }

    public boolean isClaimShortcutRestrictive() {
        return this.claimShortcutRestrictive;
    }

    public Service setClaimShortcutRestrictive(boolean restrictive) {
        this.claimShortcutRestrictive = restrictive;
        return this;
    }

    public boolean isScopeRequired() {
        return this.scopeRequired;
    }

    public Service setScopeRequired(boolean required) {
        this.scopeRequired = required;
        return this;
    }

    public boolean isNbfOptional() {
        return this.nbfOptional;
    }

    public Service setNbfOptional(boolean optional) {
        this.nbfOptional = optional;
        return this;
    }

    public boolean isIssSuppressed() {
        return this.issSuppressed;
    }

    public Service setIssSuppressed(boolean suppressed) {
        this.issSuppressed = suppressed;
        return this;
    }

    public Pair[] getAttributes() {
        return this.attributes;
    }

    public Service setAttributes(Pair[] attributes) {
        this.attributes = attributes;
        return this;
    }

    public Service loadAttributes(Iterable<Pair> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return this;
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Pair attribute : attributes) {
            if (attribute == null || attribute.getKey() == null) continue;
            list.add(attribute);
        }
        int size = list.size();
        if (size == 0) {
            this.attributes = null;
            return this;
        }
        Pair[] array = new Pair[size];
        this.attributes = list.toArray(array);
        return this;
    }

    public String[] getSupportedCustomClientMetadata() {
        return this.supportedCustomClientMetadata;
    }

    public Service setSupportedCustomClientMetadata(String[] metadata) {
        this.supportedCustomClientMetadata = metadata;
        return this;
    }

    public boolean isTokenExpirationLinked() {
        return this.tokenExpirationLinked;
    }

    public Service setTokenExpirationLinked(boolean linked) {
        this.tokenExpirationLinked = linked;
        return this;
    }

    public boolean isFrontChannelRequestObjectEncryptionRequired() {
        return this.frontChannelRequestObjectEncryptionRequired;
    }

    public Service setFrontChannelRequestObjectEncryptionRequired(boolean required) {
        this.frontChannelRequestObjectEncryptionRequired = required;
        return this;
    }

    public boolean isRequestObjectEncryptionAlgMatchRequired() {
        return this.requestObjectEncryptionAlgMatchRequired;
    }

    public Service setRequestObjectEncryptionAlgMatchRequired(boolean required) {
        this.requestObjectEncryptionAlgMatchRequired = required;
        return this;
    }

    public boolean isRequestObjectEncryptionEncMatchRequired() {
        return this.requestObjectEncryptionEncMatchRequired;
    }

    public Service setRequestObjectEncryptionEncMatchRequired(boolean required) {
        this.requestObjectEncryptionEncMatchRequired = required;
        return this;
    }

    public boolean isHsmEnabled() {
        return this.hsmEnabled;
    }

    public Service setHsmEnabled(boolean enabled) {
        this.hsmEnabled = enabled;
        return this;
    }

    public Hsk[] getHsks() {
        return this.hsks;
    }

    public Service setHsks(Hsk[] hsks) {
        this.hsks = hsks;
        return this;
    }

    public URI getGrantManagementEndpoint() {
        return this.grantManagementEndpoint;
    }

    public Service setGrantManagementEndpoint(URI endpoint) {
        this.grantManagementEndpoint = endpoint;
        return this;
    }

    public boolean isGrantManagementActionRequired() {
        return this.grantManagementActionRequired;
    }

    public Service setGrantManagementActionRequired(boolean required) {
        this.grantManagementActionRequired = required;
        return this;
    }

    public boolean isUnauthorizedOnClientConfigSupported() {
        return this.unauthorizedOnClientConfigSupported;
    }

    public Service setUnauthorizedOnClientConfigSupported(boolean supported) {
        this.unauthorizedOnClientConfigSupported = supported;
        return this;
    }

    public boolean isDcrScopeUsedAsRequestable() {
        return this.dcrScopeUsedAsRequestable;
    }

    public Service setDcrScopeUsedAsRequestable(boolean used) {
        this.dcrScopeUsedAsRequestable = used;
        return this;
    }

    public String getPredefinedTransformedClaims() {
        return this.predefinedTransformedClaims;
    }

    public Service setPredefinedTransformedClaims(String claims) {
        this.predefinedTransformedClaims = claims;
        return this;
    }

    public boolean isLoopbackRedirectionUriVariable() {
        return this.loopbackRedirectionUriVariable;
    }

    public Service setLoopbackRedirectionUriVariable(boolean variable) {
        this.loopbackRedirectionUriVariable = variable;
        return this;
    }

    public boolean isRequestObjectAudienceChecked() {
        return this.requestObjectAudienceChecked;
    }

    public Service setRequestObjectAudienceChecked(boolean checked) {
        this.requestObjectAudienceChecked = checked;
        return this;
    }

    public boolean isAccessTokenForExternalAttachmentEmbedded() {
        return this.accessTokenForExternalAttachmentEmbedded;
    }

    public Service setAccessTokenForExternalAttachmentEmbedded(boolean embedded) {
        this.accessTokenForExternalAttachmentEmbedded = embedded;
        return this;
    }

    public boolean isRefreshTokenIdempotent() {
        return this.refreshTokenIdempotent;
    }

    public Service setRefreshTokenIdempotent(boolean idempotent) {
        this.refreshTokenIdempotent = idempotent;
        return this;
    }

    public boolean isFederationEnabled() {
        return this.federationEnabled;
    }

    public Service setFederationEnabled(boolean enabled) {
        this.federationEnabled = enabled;
        return this;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Service setOrganizationName(String name) {
        this.organizationName = name;
        return this;
    }

    public URI[] getAuthorityHints() {
        return this.authorityHints;
    }

    public Service setAuthorityHints(URI[] authorityHints) {
        this.authorityHints = authorityHints;
        return this;
    }

    public TrustAnchor[] getTrustAnchors() {
        return this.trustAnchors;
    }

    public Service setTrustAnchors(TrustAnchor[] trustAnchors) {
        this.trustAnchors = trustAnchors;
        return this;
    }

    public String getFederationJwks() {
        return this.federationJwks;
    }

    public Service setFederationJwks(String jwks) {
        this.federationJwks = jwks;
        return this;
    }

    public String getFederationSignatureKeyId() {
        return this.federationSignatureKeyId;
    }

    public Service setFederationSignatureKeyId(String keyId) {
        this.federationSignatureKeyId = keyId;
        return this;
    }

    public long getFederationConfigurationDuration() {
        return this.federationConfigurationDuration;
    }

    public Service setFederationConfigurationDuration(long duration) {
        this.federationConfigurationDuration = duration;
        return this;
    }

    public URI getSignedJwksUri() {
        return this.signedJwksUri;
    }

    public Service setSignedJwksUri(URI uri) {
        this.signedJwksUri = uri;
        return this;
    }

    public URI getFederationRegistrationEndpoint() {
        return this.federationRegistrationEndpoint;
    }

    public Service setFederationRegistrationEndpoint(URI endpoint) {
        this.federationRegistrationEndpoint = endpoint;
        return this;
    }

    public ClientRegistrationType[] getSupportedClientRegistrationTypes() {
        return this.supportedClientRegistrationTypes;
    }

    public Service setSupportedClientRegistrationTypes(ClientRegistrationType[] types) {
        this.supportedClientRegistrationTypes = types;
        return this;
    }

    public boolean isTokenExchangeByIdentifiableClientsOnly() {
        return this.tokenExchangeByIdentifiableClientsOnly;
    }

    public Service setTokenExchangeByIdentifiableClientsOnly(boolean only) {
        this.tokenExchangeByIdentifiableClientsOnly = only;
        return this;
    }

    public boolean isTokenExchangeByConfidentialClientsOnly() {
        return this.tokenExchangeByConfidentialClientsOnly;
    }

    public Service setTokenExchangeByConfidentialClientsOnly(boolean only) {
        this.tokenExchangeByConfidentialClientsOnly = only;
        return this;
    }

    public boolean isTokenExchangeByPermittedClientsOnly() {
        return this.tokenExchangeByPermittedClientsOnly;
    }

    public Service setTokenExchangeByPermittedClientsOnly(boolean only) {
        this.tokenExchangeByPermittedClientsOnly = only;
        return this;
    }

    public boolean isTokenExchangeEncryptedJwtRejected() {
        return this.tokenExchangeEncryptedJwtRejected;
    }

    public Service setTokenExchangeEncryptedJwtRejected(boolean rejected) {
        this.tokenExchangeEncryptedJwtRejected = rejected;
        return this;
    }

    public boolean isTokenExchangeUnsignedJwtRejected() {
        return this.tokenExchangeUnsignedJwtRejected;
    }

    public Service setTokenExchangeUnsignedJwtRejected(boolean rejected) {
        this.tokenExchangeUnsignedJwtRejected = rejected;
        return this;
    }

    public boolean isJwtGrantByIdentifiableClientsOnly() {
        return this.jwtGrantByIdentifiableClientsOnly;
    }

    public Service setJwtGrantByIdentifiableClientsOnly(boolean only) {
        this.jwtGrantByIdentifiableClientsOnly = only;
        return this;
    }

    public boolean isJwtGrantEncryptedJwtRejected() {
        return this.jwtGrantEncryptedJwtRejected;
    }

    public Service setJwtGrantEncryptedJwtRejected(boolean rejected) {
        this.jwtGrantEncryptedJwtRejected = rejected;
        return this;
    }

    public boolean isJwtGrantUnsignedJwtRejected() {
        return this.jwtGrantUnsignedJwtRejected;
    }

    public Service setJwtGrantUnsignedJwtRejected(boolean rejected) {
        this.jwtGrantUnsignedJwtRejected = rejected;
        return this;
    }

    public boolean isDcrDuplicateSoftwareIdBlocked() {
        return this.dcrDuplicateSoftwareIdBlocked;
    }

    public Service setDcrDuplicateSoftwareIdBlocked(boolean blocked) {
        this.dcrDuplicateSoftwareIdBlocked = blocked;
        return this;
    }

    public String getResourceSignatureKeyId() {
        return this.resourceSignatureKeyId;
    }

    public Service setResourceSignatureKeyId(String keyId) {
        this.resourceSignatureKeyId = keyId;
        return this;
    }

    public boolean isRsResponseSigned() {
        return this.rsResponseSigned;
    }

    public Service setRsResponseSigned(boolean signed) {
        this.rsResponseSigned = signed;
        return this;
    }

    public boolean isOpenidDroppedOnRefreshWithoutOfflineAccess() {
        return this.openidDroppedOnRefreshWithoutOfflineAccess;
    }

    public Service setOpenidDroppedOnRefreshWithoutOfflineAccess(boolean dropped) {
        this.openidDroppedOnRefreshWithoutOfflineAccess = dropped;
        return this;
    }

    public boolean isVerifiableCredentialsEnabled() {
        return this.verifiableCredentialsEnabled;
    }

    public Service setVerifiableCredentialsEnabled(boolean enabled) {
        this.verifiableCredentialsEnabled = enabled;
        return this;
    }

    public CredentialIssuerMetadata getCredentialIssuerMetadata() {
        return this.credentialIssuerMetadata;
    }

    public Service setCredentialIssuerMetadata(CredentialIssuerMetadata metadata) {
        this.credentialIssuerMetadata = metadata;
        return this;
    }

    public long getCredentialOfferDuration() {
        return this.credentialOfferDuration;
    }

    public Service setCredentialOfferDuration(long duration) {
        this.credentialOfferDuration = duration;
        return this;
    }

    public int getUserPinLength() {
        return this.userPinLength;
    }

    public Service setUserPinLength(int length) {
        this.userPinLength = length;
        return this;
    }

    public String getIdTokenAudType() {
        return this.idTokenAudType;
    }

    public Service setIdTokenAudType(String type) {
        this.idTokenAudType = type;
        return this;
    }

    public Prompt[] getSupportedPromptValues() {
        return this.supportedPromptValues;
    }

    public Service setSupportedPromptValues(Prompt[] promptValues) {
        this.supportedPromptValues = promptValues;
        return this;
    }

    public String getVerifiedClaimsValidationSchemaSet() {
        return this.verifiedClaimsValidationSchemaSet;
    }

    public Service setVerifiedClaimsValidationSchemaSet(String schemaSet) {
        this.verifiedClaimsValidationSchemaSet = schemaSet;
        return this;
    }

    public boolean isPreAuthorizedGrantAnonymousAccessSupported() {
        return this.preAuthorizedGrantAnonymousAccessSupported;
    }

    public Service setPreAuthorizedGrantAnonymousAccessSupported(boolean supported) {
        this.preAuthorizedGrantAnonymousAccessSupported = supported;
        return this;
    }

    public long getCNonceDuration() {
        return this.cNonceDuration;
    }

    public Service setCNonceDuration(long duration) {
        this.cNonceDuration = duration;
        return this;
    }

    public long getCredentialTransactionDuration() {
        return this.credentialTransactionDuration;
    }

    public Service setCredentialTransactionDuration(long duration) {
        this.credentialTransactionDuration = duration;
        return this;
    }

    public long getCredentialDuration() {
        return this.credentialDuration;
    }

    public Service setCredentialDuration(long duration) {
        this.credentialDuration = duration;
        return this;
    }

    public String getCredentialJwks() {
        return this.credentialJwks;
    }

    public Service setCredentialJwks(String jwks) {
        this.credentialJwks = jwks;
        return this;
    }

    public boolean isIdTokenReissuable() {
        return this.idTokenReissuable;
    }

    public Service setIdTokenReissuable(boolean reissuable) {
        this.idTokenReissuable = reissuable;
        return this;
    }

    public JWSAlg[] getSupportedIntrospectionSignAlgs() {
        return this.supportedIntrospectionSignAlgs;
    }

    public Service setSupportedIntrospectionSignAlgs(JWSAlg[] algs) {
        this.supportedIntrospectionSignAlgs = algs;
        return this;
    }

    public JWEAlg[] getSupportedIntrospectionEncryptionAlgs() {
        return this.supportedIntrospectionEncryptionAlgs;
    }

    public Service setSupportedIntrospectionEncryptionAlgs(JWEAlg[] algs) {
        this.supportedIntrospectionEncryptionAlgs = algs;
        return this;
    }

    public JWEEnc[] getSupportedIntrospectionEncryptionEncs() {
        return this.supportedIntrospectionEncryptionEncs;
    }

    public Service setSupportedIntrospectionEncryptionEncs(JWEEnc[] encs) {
        this.supportedIntrospectionEncryptionEncs = encs;
        return this;
    }

    public String getIntrospectionSignatureKeyId() {
        return this.introspectionSignatureKeyId;
    }

    public Service setIntrospectionSignatureKeyId(String keyId) {
        this.introspectionSignatureKeyId = keyId;
        return this;
    }
}

