/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.authlete.common.types.UserCodeCharset;
import java.security.SecureRandom;
import java.util.Random;

public class UserCodeGenerator {
    private String mCharacters;
    private int mLength;
    private Random mRandom;

    public UserCodeGenerator() {
    }

    public UserCodeGenerator(String characters) {
        this(characters, 0, null);
    }

    public UserCodeGenerator(int length) {
        this((String)null, length, null);
    }

    public UserCodeGenerator(String characters, int length) {
        this(characters, length, null);
    }

    public UserCodeGenerator(String characters, int length, Random random) {
        this.mCharacters = characters;
        this.mLength = length;
        this.mRandom = random;
    }

    public UserCodeGenerator(UserCodeCharset charset) {
        this(charset, 0, null);
    }

    public UserCodeGenerator(UserCodeCharset charset, int length) {
        this(charset, length, null);
    }

    public UserCodeGenerator(UserCodeCharset charset, int length, Random random) {
        this(charset != null ? charset.getCharacters() : null, length, random);
    }

    public String getCharacters() {
        return this.mCharacters;
    }

    public UserCodeGenerator setCharacters(String characters) {
        this.mCharacters = characters;
        return this;
    }

    public UserCodeGenerator setCharacters(UserCodeCharset charset) {
        return this.setCharacters(charset != null ? charset.getCharacters() : null);
    }

    public int getLength() {
        return this.mLength;
    }

    public UserCodeGenerator setLength(int length) {
        this.mLength = length;
        return this;
    }

    public Random getRandom() {
        return this.mRandom;
    }

    public UserCodeGenerator setRandom(Random random) {
        this.mRandom = random;
        return this;
    }

    public String generate() {
        Random random;
        int length;
        String characters = this.getCharacters();
        if (characters == null || characters.length() == 0) {
            characters = this.getDefaultCharacters();
        }
        if ((length = this.getLength()) <= 0) {
            length = this.getDefaultLength(characters);
        }
        if ((random = this.getRandom()) == null) {
            random = this.getDefaultRandom();
        }
        return this.generate(characters, length, random);
    }

    private String generate(String characters, int length, Random random) {
        StringBuilder userCodeBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char ch = characters.charAt(index);
            userCodeBuilder.append(ch);
        }
        return userCodeBuilder.toString();
    }

    private String getDefaultCharacters() {
        return UserCodeCharset.BASE20.getCharacters();
    }

    private int getDefaultLength(String characters) {
        int n = characters.length();
        if (55 <= n) {
            return 6;
        }
        if (31 <= n) {
            return 7;
        }
        if (14 <= n) {
            return 8;
        }
        if (10 <= n) {
            return 9;
        }
        if (8 <= n) {
            return 10;
        }
        return 11;
    }

    private Random getDefaultRandom() {
        return new SecureRandom();
    }
}

