/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import java.io.Serializable;
import java.util.Objects;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int major;
    private final int minor;
    private final int patch;
    private final String string;

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.string = String.format("%d.%d.%d", major, minor, patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(Version version) {
        if (this.major != version.major) {
            return Integer.compare(this.major, version.major);
        }
        if (this.minor != version.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        return Integer.compare(this.patch, version.patch);
    }

    public boolean greaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThanOrEqualTo(Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean lessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThanOrEqualTo(Version other) {
        return this.compareTo(other) <= 0;
    }
}

