/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import com.authlete.common.assurance.Issuer;
import java.util.LinkedHashMap;
import java.util.Map;

public class Document
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String ISSUER = "issuer";
    private static final String DATE_OF_ISSUANCE = "date_of_issuance";
    private static final String DATE_OF_EXPIRY = "date_of_expiry";

    public String getType() {
        return (String)this.get(TYPE);
    }

    public Document setType(String type) {
        this.put(TYPE, type);
        return this;
    }

    public boolean containsType() {
        return this.containsKey(TYPE);
    }

    public String removeType() {
        return (String)this.remove(TYPE);
    }

    public String getNumber() {
        return (String)this.get(NUMBER);
    }

    public Document setNumber(String number) {
        this.put(NUMBER, number);
        return this;
    }

    public boolean containsNumber() {
        return this.containsKey(NUMBER);
    }

    public String removeNumber() {
        return (String)this.remove(NUMBER);
    }

    public Issuer getIssuer() {
        return (Issuer)this.get(ISSUER);
    }

    public Document setIssuer(Issuer issuer) {
        this.put(ISSUER, issuer);
        return this;
    }

    public boolean containsIssuer() {
        return this.containsKey(ISSUER);
    }

    public Issuer removeIssuer() {
        return (Issuer)this.remove(ISSUER);
    }

    public String getDateOfIssuance() {
        return (String)this.get(DATE_OF_ISSUANCE);
    }

    public Document setDateOfIssuance(String date) {
        this.put(DATE_OF_ISSUANCE, date);
        return this;
    }

    public boolean containsDateOfIssuance() {
        return this.containsKey(DATE_OF_ISSUANCE);
    }

    public String removeDateOfIssuance() {
        return (String)this.remove(DATE_OF_ISSUANCE);
    }

    public String getDateOfExpiry() {
        return (String)this.get(DATE_OF_EXPIRY);
    }

    public Document setDateOfExpiry(String date) {
        this.put(DATE_OF_EXPIRY, date);
        return this;
    }

    public boolean containsDateOfExpiry() {
        return this.containsKey(DATE_OF_EXPIRY);
    }

    public String removeDateOfExpiry() {
        return (String)this.remove(DATE_OF_EXPIRY);
    }

    public static Document extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        Document instance = new Document();
        Document.fill(instance, object, key);
        return instance;
    }

    private static void fill(Document instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        Document.fillType(instance, map, key);
        Document.fillNumber(instance, map, key);
        Document.fillIssuer(instance, map, key);
        Document.fillDateOfIssuance(instance, map, key);
        Document.fillDateOfExpiry(instance, map, key);
    }

    private static void fillType(Document instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, TYPE, key, false);
        instance.setType(value);
    }

    private static void fillNumber(Document instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, NUMBER, key, false);
        instance.setNumber(value);
    }

    private static void fillIssuer(Document instance, Map<?, ?> map, String key) {
        Issuer value = Issuer.extract(map, ISSUER);
        instance.setIssuer(value);
    }

    private static void fillDateOfIssuance(Document instance, Map<?, ?> map, String key) {
        String value = Helper.extractDate(map, DATE_OF_ISSUANCE, key, false);
        instance.setDateOfIssuance(value);
    }

    private static void fillDateOfExpiry(Document instance, Map<?, ?> map, String key) {
        String value = Helper.extractDate(map, DATE_OF_EXPIRY, key, false);
        instance.setDateOfExpiry(value);
    }
}

