/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Provider
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 2L;
    private static final String NAME = "name";
    private static final String FORMATTED = "formatted";
    private static final String STREET_ADDRESS = "street_address";
    private static final String LOCALITY = "locality";
    private static final String REGION = "region";
    private static final String POSTAL_CODE = "postal_code";
    private static final String COUNTRY = "country";

    public String getName() {
        return (String)this.get(NAME);
    }

    public Provider setName(String name) {
        this.put(NAME, name);
        return this;
    }

    public boolean containsName() {
        return this.containsKey(NAME);
    }

    public String removeName() {
        return (String)this.remove(NAME);
    }

    public String getFormatted() {
        return (String)this.get(FORMATTED);
    }

    public Provider setFormatted(String formatted) {
        this.put(FORMATTED, formatted);
        return this;
    }

    public boolean containsFormatted() {
        return this.containsKey(FORMATTED);
    }

    public String removeFormatted() {
        return (String)this.remove(FORMATTED);
    }

    public String getStreetAddress() {
        return (String)this.get(STREET_ADDRESS);
    }

    public Provider setStreetAddress(String streetAddress) {
        this.put(STREET_ADDRESS, streetAddress);
        return this;
    }

    public boolean containsStreetAddress() {
        return this.containsKey(STREET_ADDRESS);
    }

    public String removeStreetAddress() {
        return (String)this.remove(STREET_ADDRESS);
    }

    public String getLocality() {
        return (String)this.get(LOCALITY);
    }

    public Provider setLocality(String locality) {
        this.put(LOCALITY, locality);
        return this;
    }

    public boolean containsLocality() {
        return this.containsKey(LOCALITY);
    }

    public String removeLocality() {
        return (String)this.remove(LOCALITY);
    }

    public String getRegion() {
        return (String)this.get(REGION);
    }

    public Provider setRegion(String region) {
        this.put(REGION, region);
        return this;
    }

    public boolean containsRegion() {
        return this.containsKey(REGION);
    }

    public String removeRegion() {
        return (String)this.remove(REGION);
    }

    public String getPostalCode() {
        return (String)this.get(POSTAL_CODE);
    }

    public Provider setPostalCode(String postalCode) {
        this.put(POSTAL_CODE, postalCode);
        return this;
    }

    public boolean containsPostalCode() {
        return this.containsKey(POSTAL_CODE);
    }

    public String removePostalCode() {
        return (String)this.remove(POSTAL_CODE);
    }

    public String getCountry() {
        return (String)this.get(COUNTRY);
    }

    public Provider setCountry(String country) {
        this.put(COUNTRY, country);
        return this;
    }

    public boolean containsCountry() {
        return this.containsKey(COUNTRY);
    }

    public String removeCountry() {
        return (String)this.remove(COUNTRY);
    }

    public static Provider extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        Provider instance = new Provider();
        Provider.fill(instance, object, key);
        return instance;
    }

    private static void fill(Provider instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        Provider.fillName(instance, map, key);
        Provider.fillFormatted(instance, map, key);
        Provider.fillStreetAddress(instance, map, key);
        Provider.fillLocality(instance, map, key);
        Provider.fillRegion(instance, map, key);
        Provider.fillPostalCode(instance, map, key);
        Provider.fillCountry(instance, map, key);
    }

    private static void fillName(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, NAME, key, false);
        instance.setName(value);
    }

    private static void fillFormatted(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, FORMATTED, key, false);
        instance.setFormatted(value);
    }

    private static void fillStreetAddress(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, STREET_ADDRESS, key, false);
        instance.setStreetAddress(value);
    }

    private static void fillLocality(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, LOCALITY, key, false);
        instance.setLocality(value);
    }

    private static void fillRegion(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, REGION, key, false);
        instance.setRegion(value);
    }

    private static void fillPostalCode(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, POSTAL_CODE, key, false);
        instance.setPostalCode(value);
    }

    private static void fillCountry(Provider instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, COUNTRY, key, false);
        instance.setCountry(value);
    }
}

