/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Evidence;
import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import com.authlete.common.assurance.Provider;
import java.util.Map;

public class UtilityBill
extends Evidence {
    private static final long serialVersionUID = 1L;
    private static final String UTILITY_BILL = "utility_bill";
    private static final String PROVIDER = "provider";
    private static final String DATE = "date";

    public UtilityBill() {
        super(UTILITY_BILL);
    }

    public Provider getProvider() {
        return (Provider)this.get(PROVIDER);
    }

    public UtilityBill setProvider(Provider provider) {
        this.put(PROVIDER, provider);
        return this;
    }

    public boolean containsProvider() {
        return this.containsKey(PROVIDER);
    }

    public Provider removeProvider() {
        return (Provider)this.remove(PROVIDER);
    }

    public String getDate() {
        return (String)this.get(DATE);
    }

    public UtilityBill setDate(String date) {
        this.put(DATE, date);
        return this;
    }

    public boolean containsDate() {
        return this.containsKey(DATE);
    }

    public String removeDate() {
        return (String)this.remove(DATE);
    }

    public static UtilityBill extract(Map<?, ?> map) throws IdentityAssuranceException {
        UtilityBill instance = new UtilityBill();
        UtilityBill.fill(instance, map, UTILITY_BILL);
        return instance;
    }

    private static void fill(UtilityBill instance, Map<?, ?> map, String key) {
        UtilityBill.fillProvider(instance, map, key);
        UtilityBill.fillDate(instance, map, key);
    }

    private static void fillProvider(UtilityBill instance, Map<?, ?> map, String key) {
        Helper.ensureKey(map, PROVIDER, key);
        Provider provider = Provider.extract(map, PROVIDER);
        Helper.ensureNotNull(provider, PROVIDER);
        instance.setProvider(provider);
    }

    private static void fillDate(UtilityBill instance, Map<?, ?> map, String key) {
        String value = Helper.extractDate(map, DATE, key, true);
        instance.setDate(value);
    }
}

