/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Evidence;
import com.authlete.common.assurance.EvidenceArray;
import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Verification
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String TRUST_FRAMEWORK = "trust_framework";
    private static final String TIME = "time";
    private static final String VERIFICATION_PROCESS = "verification_process";
    private static final String EVIDENCE = "evidence";
    private static final Set<String> KEYS = new HashSet<String>();

    public String getTrustFramework() {
        return (String)this.get(TRUST_FRAMEWORK);
    }

    public Verification setTrustFramework(String framework) {
        this.put(TRUST_FRAMEWORK, framework);
        return this;
    }

    public boolean containsTrustFramework() {
        return this.containsKey(TRUST_FRAMEWORK);
    }

    public String removeTrustFramework() {
        return (String)this.remove(TRUST_FRAMEWORK);
    }

    public String getTime() {
        return (String)this.get(TIME);
    }

    public Verification setTime(String time) {
        this.put(TIME, time);
        return this;
    }

    public boolean containsTime() {
        return this.containsKey(TIME);
    }

    public String removeTime() {
        return (String)this.remove(TIME);
    }

    public String getVerificationProcess() {
        return (String)this.get(VERIFICATION_PROCESS);
    }

    public Verification setVerificationProcess(String process) {
        this.put(VERIFICATION_PROCESS, process);
        return this;
    }

    public boolean containsVerificationProcess() {
        return this.containsKey(VERIFICATION_PROCESS);
    }

    public String removeVerificationProcess() {
        return (String)this.remove(VERIFICATION_PROCESS);
    }

    public EvidenceArray getEvidence() {
        return (EvidenceArray)this.get(EVIDENCE);
    }

    public Verification setEvidence(EvidenceArray evidence) {
        this.put(EVIDENCE, evidence);
        return this;
    }

    public boolean containsEvidence() {
        return this.containsKey(EVIDENCE);
    }

    public EvidenceArray removeEvidence() {
        return (EvidenceArray)this.remove(EVIDENCE);
    }

    public Verification addEvidence(Evidence evidence) {
        EvidenceArray list = this.getEvidence();
        if (list == null) {
            list = new EvidenceArray();
            this.put(EVIDENCE, list);
        }
        list.add(evidence);
        return this;
    }

    public static Verification extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        Verification verification = new Verification();
        Verification.fill(verification, object, key);
        return verification;
    }

    private static void fill(Verification instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        Verification.fillTrustFramework(instance, map, key);
        Verification.fillTime(instance, map, key);
        Verification.fillVerificationProcess(instance, map, key);
        Verification.fillEvidence(instance, map, key);
        Helper.ensureNoAdditionalProperties(map, key, KEYS);
    }

    private static void fillTrustFramework(Verification instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, TRUST_FRAMEWORK, key, true);
        instance.setTrustFramework(value);
    }

    private static void fillTime(Verification instance, Map<?, ?> map, String key) {
        String value = Helper.extractDateTime(map, TIME, key, false);
        instance.setTime(value);
    }

    private static void fillVerificationProcess(Verification instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, VERIFICATION_PROCESS, key, false);
        instance.setVerificationProcess(value);
    }

    private static void fillEvidence(Verification instance, Map<?, ?> map, String key) {
        EvidenceArray value = EvidenceArray.extract(map, EVIDENCE);
        instance.setEvidence(value);
    }

    static {
        KEYS.add(TRUST_FRAMEWORK);
        KEYS.add(TIME);
        KEYS.add(VERIFICATION_PROCESS);
        KEYS.add(EVIDENCE);
    }
}

