/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance;

import com.authlete.common.assurance.Helper;
import com.authlete.common.assurance.IdentityAssuranceException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Verifier
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String ORGANIZATION = "organization";
    private static final String TXN = "txn";

    public String getOrganization() {
        return (String)this.get(ORGANIZATION);
    }

    public Verifier setOrganization(String organization) {
        this.put(ORGANIZATION, organization);
        return this;
    }

    public boolean containsOrganization() {
        return this.containsKey(ORGANIZATION);
    }

    public String removeOrganization() {
        return (String)this.remove(ORGANIZATION);
    }

    public String getTxn() {
        return (String)this.get(TXN);
    }

    public Verifier setTxn(String txn) {
        this.put(TXN, txn);
        return this;
    }

    public boolean containsTxn() {
        return this.containsKey(TXN);
    }

    public String removeTxn() {
        return (String)this.remove(TXN);
    }

    public static Verifier extract(Map<?, ?> map, String key) throws IdentityAssuranceException {
        Object object = map.get(key);
        if (object == null) {
            return null;
        }
        Verifier instance = new Verifier();
        Verifier.fill(instance, object, key);
        return instance;
    }

    private static void fill(Verifier instance, Object object, String key) {
        Map<?, ?> map = Helper.ensureMap(object, key);
        Verifier.fillOrganization(instance, map, key);
        Verifier.fillTxn(instance, map, key);
    }

    private static void fillOrganization(Verifier instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, ORGANIZATION, key, false);
        instance.setOrganization(value);
    }

    private static void fillTxn(Verifier instance, Map<?, ?> map, String key) {
        String value = Helper.extractString(map, TXN, key, false);
        instance.setTxn(value);
    }
}

