/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.Constraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.VerifiedClaimConstraint;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClaimsConstraint
extends LinkedHashMap<String, VerifiedClaimConstraint>
implements Constraint {
    private static final long serialVersionUID = 2L;
    private boolean exists;
    private boolean isNull;

    @Override
    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    public ClaimsConstraint putClaim(String claimName, VerifiedClaimConstraint constraint) {
        this.put(claimName, constraint);
        return this;
    }

    public static ClaimsConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        ClaimsConstraint instance = new ClaimsConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            ClaimsConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    private static void fill(ClaimsConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw Helper.exception("A key in '%s' is not a string.", key);
            }
            String name = (String)entry.getKey();
            VerifiedClaimConstraint constraint = VerifiedClaimConstraint.extract(entry.getValue(), name);
            instance.put(name, constraint);
        }
    }

    public Map<String, Object> toMap() {
        if (!this.exists || this.isNull) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : this.entrySet()) {
            map.put((String)entry.getKey(), ((VerifiedClaimConstraint)entry.getValue()).toMap());
        }
        return map;
    }

    public String toJson() {
        return Helper.toJson(this.toMap());
    }

    public String toJson(boolean pretty) {
        return Helper.toJson(this.toMap(), pretty);
    }
}

