/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.ClaimsConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import com.authlete.common.assurance.constraint.VerifiedClaimConstraint;
import com.authlete.common.assurance.constraint.VerifiedClaimsConstraint;
import com.authlete.common.assurance.constraint.VerifiedClaimsContainerConstraint;
import java.util.Map;

public class ConstraintValidator {
    private static final int PURPOSE_LEN_MIN = 3;
    private static final int PURPOSE_LEN_MAX = 300;

    public void validate(VerifiedClaimsContainerConstraint container) throws ConstraintException {
        if (container == null) {
            return;
        }
        if (!container.exists()) {
            return;
        }
        this.validate(container.getVerifiedClaims());
    }

    public void validate(VerifiedClaimsConstraint verifiedClaims) throws ConstraintException {
        if (verifiedClaims == null) {
            return;
        }
        if (!verifiedClaims.exists()) {
            return;
        }
        if (verifiedClaims.isNull()) {
            return;
        }
        this.validate(verifiedClaims.getClaims());
    }

    public void validate(ClaimsConstraint claims) throws ConstraintException {
        if (claims == null) {
            return;
        }
        if (!claims.exists()) {
            throw Helper.exception("'claims' is not included.", new Object[0]);
        }
        if (claims.isNull()) {
            throw Helper.exception("'claims' is null.", new Object[0]);
        }
        if (claims.size() == 0) {
            throw Helper.exception("'claims' is empty.", new Object[0]);
        }
        for (Map.Entry entry : claims.entrySet()) {
            this.validate((String)entry.getKey(), (VerifiedClaimConstraint)entry.getValue());
        }
    }

    public void validate(String key, VerifiedClaimConstraint verifiedClaim) throws ConstraintException {
        if (verifiedClaim == null) {
            return;
        }
        if (!verifiedClaim.exists()) {
            return;
        }
        if (verifiedClaim.isNull()) {
            return;
        }
        this.validatePurpose(key, verifiedClaim.getPurpose());
    }

    public void validatePurpose(String key, String purpose) throws ConstraintException {
        if (purpose == null) {
            return;
        }
        int len = purpose.length();
        if (len < 3) {
            throw Helper.exception("The purpose of '%s' is shorter than %d.", key, 3);
        }
        if (300 < len) {
            throw Helper.exception("The purpose of '%s' is longer than %d.", key, 300);
        }
    }
}

