/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.assurance.constraint;

import com.authlete.common.assurance.constraint.BaseConstraint;
import com.authlete.common.assurance.constraint.ConstraintException;
import com.authlete.common.assurance.constraint.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LeafConstraint
extends BaseConstraint {
    private boolean essential;
    private String value;
    private String[] values;
    private boolean essentialExists;
    private boolean valueExists;
    private boolean valuesExists;

    public boolean isEssential() {
        return this.essential;
    }

    public void setEssential(boolean essential) {
        this.essential = essential;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public static LeafConstraint extract(Map<?, ?> map, String key) throws ConstraintException {
        LeafConstraint instance = new LeafConstraint();
        instance.setExists(map.containsKey(key));
        if (instance.exists()) {
            LeafConstraint.fill(instance, map.get(key), key);
        }
        return instance;
    }

    static void fill(LeafConstraint instance, Object object, String key) {
        if (object == null) {
            instance.setNull(true);
            return;
        }
        Map<?, ?> map = Helper.ensureMap(object, key);
        LeafConstraint.fillEssential(instance, map);
        LeafConstraint.fillValue(instance, map);
        LeafConstraint.fillValues(instance, map);
    }

    private static void fillEssential(LeafConstraint instance, Map<?, ?> map) {
        instance.essentialExists = map.containsKey("essential");
        if (instance.essentialExists) {
            instance.essential = LeafConstraint.extractBoolean(map, "essential");
        }
    }

    private static boolean extractBoolean(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return Helper.ensureBoolean(value, key);
    }

    private static void fillValue(LeafConstraint instance, Map<?, ?> map) {
        instance.valueExists = map.containsKey("value");
        if (instance.valueExists) {
            instance.value = LeafConstraint.extractString(map, "value");
        }
    }

    static String extractString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        return Helper.ensureString(value, key);
    }

    private static void fillValues(LeafConstraint instance, Map<?, ?> map) {
        instance.valuesExists = map.containsKey("values");
        if (instance.valuesExists) {
            instance.values = LeafConstraint.extractStringArray(map, "values");
        }
    }

    private static String[] extractStringArray(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        List<?> list = Helper.ensureList(value, key);
        int size = list.size();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            Object element = list.get(i);
            if (element != null && !(element instanceof String)) {
                throw Helper.exception("'%s[%d]' is not a string.", key, i);
            }
            array[i] = (String)element;
        }
        return array;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (map == null) {
            return null;
        }
        if (this.essentialExists) {
            map.put("essential", this.essential);
        }
        if (this.valueExists) {
            map.put("value", this.value);
        }
        if (this.valuesExists) {
            List<String> list = this.values == null ? null : Arrays.asList(this.values);
            map.put("values", list);
        }
        return map;
    }
}

