/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.types.JWEAlg;
import com.authlete.common.types.JWEEnc;
import com.authlete.common.util.MapUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class CredentialIssuerMetadata
implements Serializable {
    private static final long serialVersionUID = 4L;
    private URI credentialIssuer;
    private URI[] authorizationServers;
    private URI credentialEndpoint;
    private URI batchCredentialEndpoint;
    private URI deferredCredentialEndpoint;
    private JWEAlg[] credentialResponseEncryptionAlgValuesSupported;
    private JWEEnc[] credentialResponseEncryptionEncValuesSupported;
    private boolean requireCredentialResponseEncryption;
    private String credentialsSupported;

    public CredentialIssuerMetadata() {
    }

    public CredentialIssuerMetadata(CredentialIssuerMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.credentialIssuer = metadata.getCredentialIssuer();
        this.authorizationServers = metadata.getAuthorizationServers();
        this.credentialEndpoint = metadata.getCredentialEndpoint();
        this.batchCredentialEndpoint = metadata.getBatchCredentialEndpoint();
        this.deferredCredentialEndpoint = metadata.getDeferredCredentialEndpoint();
        this.credentialResponseEncryptionAlgValuesSupported = metadata.getCredentialResponseEncryptionAlgValuesSupported();
        this.credentialResponseEncryptionEncValuesSupported = metadata.getCredentialResponseEncryptionEncValuesSupported();
        this.requireCredentialResponseEncryption = metadata.isRequireCredentialResponseEncryption();
        this.credentialsSupported = metadata.getCredentialsSupported();
    }

    public URI getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialIssuerMetadata setCredentialIssuer(URI issuer) {
        this.credentialIssuer = issuer;
        return this;
    }

    public URI[] getAuthorizationServers() {
        return this.authorizationServers;
    }

    public CredentialIssuerMetadata setAuthorizationServers(URI[] servers) {
        this.authorizationServers = servers;
        return this;
    }

    public URI getCredentialEndpoint() {
        return this.credentialEndpoint;
    }

    public CredentialIssuerMetadata setCredentialEndpoint(URI endpoint) {
        this.credentialEndpoint = endpoint;
        return this;
    }

    public URI getBatchCredentialEndpoint() {
        return this.batchCredentialEndpoint;
    }

    public CredentialIssuerMetadata setBatchCredentialEndpoint(URI endpoint) {
        this.batchCredentialEndpoint = endpoint;
        return this;
    }

    public URI getDeferredCredentialEndpoint() {
        return this.deferredCredentialEndpoint;
    }

    public CredentialIssuerMetadata setDeferredCredentialEndpoint(URI endpoint) {
        this.deferredCredentialEndpoint = endpoint;
        return this;
    }

    public JWEAlg[] getCredentialResponseEncryptionAlgValuesSupported() {
        return this.credentialResponseEncryptionAlgValuesSupported;
    }

    public CredentialIssuerMetadata setCredentialResponseEncryptionAlgValuesSupported(JWEAlg[] algs) {
        this.credentialResponseEncryptionAlgValuesSupported = algs;
        return this;
    }

    public JWEEnc[] getCredentialResponseEncryptionEncValuesSupported() {
        return this.credentialResponseEncryptionEncValuesSupported;
    }

    public CredentialIssuerMetadata setCredentialResponseEncryptionEncValuesSupported(JWEEnc[] encs) {
        this.credentialResponseEncryptionEncValuesSupported = encs;
        return this;
    }

    public boolean isRequireCredentialResponseEncryption() {
        return this.requireCredentialResponseEncryption;
    }

    public CredentialIssuerMetadata setRequireCredentialResponseEncryption(boolean required) {
        this.requireCredentialResponseEncryption = required;
        return this;
    }

    public String getCredentialsSupported() {
        return this.credentialsSupported;
    }

    public CredentialIssuerMetadata setCredentialsSupported(String credentialsSupported) {
        this.credentialsSupported = credentialsSupported;
        return this;
    }

    public boolean isEmpty() {
        return this.credentialIssuer == null && this.authorizationServers == null && this.credentialEndpoint == null && this.batchCredentialEndpoint == null && this.deferredCredentialEndpoint == null && this.credentialResponseEncryptionAlgValuesSupported == null && this.credentialResponseEncryptionEncValuesSupported == null && this.credentialsSupported == null;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        MapUtils.put(map, "credential_issuer", this.credentialIssuer, false);
        MapUtils.put(map, "authorization_servers", this.authorizationServers, false);
        MapUtils.put(map, "credential_endpoint", this.credentialEndpoint, false);
        MapUtils.put(map, "batch_credential_endpoint", this.batchCredentialEndpoint, false);
        MapUtils.put(map, "deferred_credential_endpoint", this.deferredCredentialEndpoint, false);
        MapUtils.put(map, "credential_response_encryption", this.credentialResponseEncryption(), false);
        try {
            MapUtils.putJsonObject(map, "credential_configurations_supported", this.credentialsSupported, false);
        }
        catch (Exception cause) {
            throw new IllegalStateException("The value of the 'credentialsSupported' property failed to be parsed as a JSON object.", cause);
        }
        return map;
    }

    private Map<String, Object> credentialResponseEncryption() {
        if (this.credentialResponseEncryptionAlgValuesSupported == null || this.credentialResponseEncryptionAlgValuesSupported.length == 0 || this.credentialResponseEncryptionEncValuesSupported == null || this.credentialResponseEncryptionEncValuesSupported.length == 0) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        MapUtils.put(map, "alg_values_supported", this.credentialResponseEncryptionAlgValuesSupported, true);
        MapUtils.put(map, "enc_values_supported", this.credentialResponseEncryptionEncValuesSupported, true);
        MapUtils.put(map, "encryption_required", this.requireCredentialResponseEncryption, true);
        return map;
    }
}

