/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.Property;
import com.authlete.common.util.Utils;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;

public class DeviceCompleteRequest
implements Serializable {
    private static final long serialVersionUID = 6L;
    private String userCode;
    private Result result;
    private String subject;
    private String sub;
    private long authTime;
    private String acr;
    private String claims;
    private Property[] properties;
    private String[] scopes;
    private String idtHeaderParams;
    private String[] consentedClaims;
    private String jwtAtClaims;
    private String idTokenAudType;
    private String errorDescription;
    private URI errorUri;

    public String getUserCode() {
        return this.userCode;
    }

    public DeviceCompleteRequest setUserCode(String userCode) {
        this.userCode = userCode;
        return this;
    }

    public Result getResult() {
        return this.result;
    }

    public DeviceCompleteRequest setResult(Result result) {
        this.result = result;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public DeviceCompleteRequest setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getSub() {
        return this.sub;
    }

    public DeviceCompleteRequest setSub(String sub) {
        this.sub = sub;
        return this;
    }

    public long getAuthTime() {
        return this.authTime;
    }

    public DeviceCompleteRequest setAuthTime(long authTime) {
        this.authTime = authTime;
        return this;
    }

    public String getAcr() {
        return this.acr;
    }

    public DeviceCompleteRequest setAcr(String acr) {
        this.acr = acr;
        return this;
    }

    public String getClaims() {
        return this.claims;
    }

    public DeviceCompleteRequest setClaims(String claims) {
        this.claims = claims;
        return this;
    }

    public DeviceCompleteRequest setClaims(Map<String, Object> claims) {
        if (claims == null || claims.size() == 0) {
            this.claims = null;
        } else {
            this.setClaims(Utils.toJson(claims));
        }
        return this;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public DeviceCompleteRequest setProperties(Property[] properties) {
        this.properties = properties;
        return this;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public DeviceCompleteRequest setScopes(String[] scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getIdtHeaderParams() {
        return this.idtHeaderParams;
    }

    public DeviceCompleteRequest setIdtHeaderParams(String params) {
        this.idtHeaderParams = params;
        return this;
    }

    public String[] getConsentedClaims() {
        return this.consentedClaims;
    }

    public DeviceCompleteRequest setConsentedClaims(String[] claims) {
        this.consentedClaims = claims;
        return this;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public DeviceCompleteRequest setErrorDescription(String description) {
        this.errorDescription = description;
        return this;
    }

    public URI getErrorUri() {
        return this.errorUri;
    }

    public DeviceCompleteRequest setErrorUri(URI uri) {
        this.errorUri = uri;
        return this;
    }

    public String getJwtAtClaims() {
        return this.jwtAtClaims;
    }

    public DeviceCompleteRequest setJwtAtClaims(String claims) {
        this.jwtAtClaims = claims;
        return this;
    }

    public String getIdTokenAudType() {
        return this.idTokenAudType;
    }

    public DeviceCompleteRequest setIdTokenAudType(String type) {
        this.idTokenAudType = type;
        return this;
    }

    public static enum Result {
        AUTHORIZED(1),
        ACCESS_DENIED(2),
        TRANSACTION_FAILED(3);

        private static final Result[] sValues;
        private final short mValue;

        private Result(short value) {
            this.mValue = value;
        }

        public short getValue() {
            return this.mValue;
        }

        public static Result getByValue(short value) {
            if (value < 1 || sValues.length < value) {
                return null;
            }
            return sValues[value - 1];
        }

        static {
            sValues = Result.values();
        }
    }
}

