/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.AuthzDetailsSerializer;
import com.authlete.common.dto.Grant;
import com.authlete.common.util.BaseJsonSerializer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GrantSerializer
extends BaseJsonSerializer
implements JsonSerializer<Grant> {
    public JsonElement serialize(Grant grant, Type type, JsonSerializationContext context) {
        if (grant == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jGrant = new JsonObject();
        this.addScopes(grant, jGrant);
        this.addClaims(grant, jGrant);
        this.addAuthorizationDetails(grant, jGrant);
        return jGrant;
    }

    private void addScopes(Grant grant, JsonObject jGrant) {
        JsonElement element = new Gson().toJsonTree((Object)grant.getScopes());
        this.addUnlessNull(jGrant, "scopes", element);
    }

    private void addClaims(Grant grant, JsonObject jGrant) {
        JsonElement element = this.fromStringArray(grant.getClaims());
        this.addUnlessNull(jGrant, "claims", element);
    }

    private void addAuthorizationDetails(Grant grant, JsonObject jGrant) {
        JsonElement element = new AuthzDetailsSerializer().serialize(grant.getAuthorizationDetails(), null, null);
        this.addUnlessNull(jGrant, "authorization_details", element);
    }
}

