/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.Pair;
import com.authlete.common.dto.TaggedValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

public class Scope
implements Serializable {
    private static final long serialVersionUID = 3L;
    private String name;
    private boolean defaultEntry;
    private String description;
    private TaggedValue[] descriptions;
    private Pair[] attributes;

    public String getName() {
        return this.name;
    }

    public Scope setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public Scope setDefaultEntry(boolean defaultEntry) {
        this.defaultEntry = defaultEntry;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Scope setDescription(String description) {
        this.description = description;
        return this;
    }

    public TaggedValue[] getDescriptions() {
        return this.descriptions;
    }

    public Scope setDescriptions(TaggedValue[] descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public Pair[] getAttributes() {
        return this.attributes;
    }

    public Scope setAttributes(Pair[] attributes) {
        this.attributes = attributes;
        return this;
    }

    public Scope setAttributes(Iterable<Pair> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return this;
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Pair attribute : attributes) {
            if (attribute == null || attribute.getKey() == null) continue;
            list.add(attribute);
        }
        int size = list.size();
        if (size == 0) {
            this.attributes = null;
            return this;
        }
        Pair[] array = new Pair[size];
        this.attributes = list.toArray(array);
        return this;
    }

    public static String[] extractNames(Scope[] scopes) {
        if (scopes == null) {
            return null;
        }
        String[] names = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope = scopes[i];
            names[i] = scope == null ? null : scope.getName();
        }
        return names;
    }

    public static class NameComparator
    implements Comparator<Scope>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Scope a, Scope b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return this.compareNames(a.getName(), b.getName());
        }

        private int compareNames(String a, String b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }
    }
}

