/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.ida;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class ClaimRequirement {
    private static final String KEY_ESSENTIAL = "essential";
    private static final String KEY_VALUE = "value";
    private static final String KEY_VALUES = "values";
    private static final String KEY_MAX_AGE = "max_age";
    private static final String KEY_PURPOSE = "purpose";
    private static final Set<String> RESERVED_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("essential", "value", "values", "max_age", "purpose")));
    private String mValue;
    private List<String> mValues;
    private Long mMaxAge;
    private Set<String> mUnreservedKeys;

    ClaimRequirement() {
    }

    public String getValue() {
        return this.mValue;
    }

    public ClaimRequirement setValue(String value) {
        this.mValue = value;
        return this;
    }

    public List<String> getValues() {
        return this.mValues;
    }

    public ClaimRequirement setValues(List<String> values) {
        this.mValues = values;
        return this;
    }

    public Long getMaxAge() {
        return this.mMaxAge;
    }

    public ClaimRequirement setMaxAge(Long maxAge) {
        this.mMaxAge = maxAge;
        return this;
    }

    public Set<String> getUnreservedKeys() {
        return this.mUnreservedKeys;
    }

    public ClaimRequirement setUnreservedKeys(Set<String> keys) {
        this.mUnreservedKeys = keys;
        return this;
    }

    public boolean hasUnreservedKeys() {
        return this.mUnreservedKeys != null && 0 < this.mUnreservedKeys.size();
    }

    public static Set<String> getReservedKeys() {
        return RESERVED_KEYS;
    }

    public static ClaimRequirement parse(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        String value = ClaimRequirement.extractAsString(map, KEY_VALUE);
        List<String> values = ClaimRequirement.extractAsStringList(map, KEY_VALUES);
        Long maxAge = ClaimRequirement.extractAsLong(map, KEY_MAX_AGE);
        Set<String> unreservedKeys = map.keySet().stream().filter(key -> !RESERVED_KEYS.contains(key)).collect(Collectors.toSet());
        if (unreservedKeys.size() == 0) {
            unreservedKeys = null;
        }
        if (value == null && values == null && maxAge == null) {
            return null;
        }
        return new ClaimRequirement().setValue(value).setValues(values).setMaxAge(maxAge).setUnreservedKeys(unreservedKeys);
    }

    private static String extractAsString(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static List<String> extractAsStringList(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (!(value instanceof List)) {
            return null;
        }
        for (Object element2 : (List)value) {
            if (element2 instanceof String) continue;
            return null;
        }
        return ((List)value).stream().map(element -> (String)element).collect(Collectors.toList());
    }

    private static Long extractAsLong(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }
}

