/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.ida;

import com.authlete.common.ida.ClaimRequirement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;

class ClaimRequirementChecker {
    private static final List<DateTimeFormatter> DATETIME_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX"));
    private final ClaimRequirement mRequirement;
    private final OffsetDateTime mCurrentTime;

    public ClaimRequirementChecker(ClaimRequirement requirement) {
        this(requirement, null);
    }

    public ClaimRequirementChecker(ClaimRequirement requirement, OffsetDateTime currentTime) {
        if (requirement == null) {
            throw new IllegalArgumentException("'requirement' must not be null.");
        }
        this.mRequirement = requirement;
        this.mCurrentTime = currentTime != null ? currentTime : OffsetDateTime.now(ZoneOffset.UTC);
    }

    private ClaimRequirement getRequirement() {
        return this.mRequirement;
    }

    private OffsetDateTime getCurrentTime() {
        return this.mCurrentTime;
    }

    public boolean check(Object value) {
        ClaimRequirement requirement = this.getRequirement();
        boolean satisfied = true;
        if (requirement.getValue() != null) {
            satisfied &= ClaimRequirementChecker.checkWithValue(value, requirement.getValue());
        }
        if (satisfied && requirement.getValues() != null) {
            satisfied &= ClaimRequirementChecker.checkWithValues(value, requirement.getValues());
        }
        if (satisfied && requirement.getMaxAge() != null) {
            satisfied &= ClaimRequirementChecker.checkWithMaxAge(value, requirement.getMaxAge(), this.getCurrentTime());
        }
        return satisfied;
    }

    private static String interpretAsString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static boolean checkWithValue(Object value, String expected) {
        String actual = ClaimRequirementChecker.interpretAsString(value);
        if (actual == null) {
            return false;
        }
        return actual.equals(expected);
    }

    private static boolean checkWithValues(Object value, List<String> expected) {
        String actual = ClaimRequirementChecker.interpretAsString(value);
        if (actual == null) {
            return false;
        }
        return expected.stream().anyMatch(element -> actual.equals(element));
    }

    private static boolean checkWithMaxAge(Object value, Long maxAge, OffsetDateTime currentTime) {
        OffsetDateTime origin = ClaimRequirementChecker.parseAsDateTime(value);
        if (origin == null) {
            return false;
        }
        OffsetDateTime expiration = origin.plusSeconds(maxAge);
        return currentTime.isBefore(expiration);
    }

    private static OffsetDateTime parseAsDateTime(Object value) {
        String string = ClaimRequirementChecker.interpretAsString(value);
        if (string == null) {
            return null;
        }
        if (string.length() <= 10) {
            try {
                return LocalDate.parse(string).atTime(0, 0).atOffset(ZoneOffset.UTC);
            }
            catch (Exception cause) {
                return null;
            }
        }
        try {
            return LocalDateTime.parse(string).atOffset(ZoneOffset.UTC);
        }
        catch (Exception exception) {
            try {
                return OffsetDateTime.parse(string);
            }
            catch (Exception exception2) {
                for (DateTimeFormatter formatter : DATETIME_FORMATTERS) {
                    try {
                        return OffsetDateTime.parse(string, formatter);
                    }
                    catch (Exception exception3) {
                    }
                }
                return null;
            }
        }
    }
}

