/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.ida;

import com.authlete.common.ida.ClaimRequirement;
import com.authlete.common.ida.ClaimRequirementChecker;
import com.authlete.common.ida.DatasetContext;
import com.authlete.common.ida.DatasetExtractorMessageCode;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DatasetExtractor {
    private static final String KEY_VERIFICATION = "verification";
    private static final String KEY_ASSURANCE_DETAILS = "assurance_details";
    private final OffsetDateTime mCurrentTime;
    private boolean mTransformedClaimAware = true;
    private Logger mLogger;

    public DatasetExtractor() {
        this(null);
    }

    public DatasetExtractor(OffsetDateTime currentTime) {
        this.mCurrentTime = currentTime != null ? currentTime : OffsetDateTime.now(ZoneOffset.UTC);
    }

    public boolean isTransformedClaimAware() {
        return this.mTransformedClaimAware;
    }

    public DatasetExtractor setTransformedClaimAware(boolean aware) {
        this.mTransformedClaimAware = aware;
        return this;
    }

    public DatasetExtractor setLogger(Logger logger) {
        this.mLogger = logger;
        return this;
    }

    private OffsetDateTime getCurrentTime() {
        return this.mCurrentTime;
    }

    public Map<String, Object> extract(Map<String, Object> request, List<Map<String, Object>> originalDatasets) {
        if (request == null || originalDatasets == null) {
            return null;
        }
        for (Map<String, Object> original : originalDatasets) {
            Map<String, Object> dataset;
            if (!(original instanceof Map) || (dataset = this.extract(null, request, original)) == null) continue;
            return dataset;
        }
        return null;
    }

    public Map<String, Object> extract(Map<String, Object> request, Map<String, Object> original) {
        return this.extract(null, request, original);
    }

    private Map<String, Object> extract(DatasetContext context, Map<String, Object> request, Map<String, Object> original) {
        boolean continued;
        HashMap<String, Object> copy = new HashMap<String, Object>();
        if (context == null) {
            context = new DatasetContext();
        }
        return (continued = this.processMap(context, request, original, copy)) ? copy : null;
    }

    private boolean processMap(DatasetContext context, Map<String, Object> request, Map<String, Object> original, Map<String, Object> copy) {
        for (Map.Entry<String, Object> requestEntry : request.entrySet()) {
            String requestKey = requestEntry.getKey();
            if (ClaimRequirement.getReservedKeys().contains(requestKey)) continue;
            boolean asFilter = context.isConstraintAsFilter();
            if (requestKey.equals(KEY_VERIFICATION)) {
                context.setConstraintAsFilter(true);
            }
            context.updatePointers(requestKey);
            boolean continued = this.processEntry(context, requestKey, requestEntry.getValue(), original, copy);
            context.restorePointers();
            context.setConstraintAsFilter(asFilter);
            if (continued) continue;
            return false;
        }
        return true;
    }

    private boolean processEntry(DatasetContext context, String requestKey, Object requestValue, Map<String, Object> original, Map<String, Object> copy) {
        Object originalValue = original.get(requestKey);
        if (this.isTransformedClaim(requestKey)) {
            this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE01, new Object[0]);
            copy.put(requestKey, requestValue);
            return true;
        }
        if (originalValue == null) {
            this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE02, new Object[0]);
            return true;
        }
        if (requestKey.equals(KEY_ASSURANCE_DETAILS)) {
            this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE23, new Object[0]);
            copy.put(requestKey, originalValue);
            return true;
        }
        if (requestValue == null) {
            if (originalValue instanceof Map || originalValue instanceof List) {
                this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE03, new Object[0]);
                return true;
            }
            this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE04, new Object[0]);
            copy.put(requestKey, originalValue);
            return true;
        }
        if (requestValue instanceof Map) {
            return this.processEntryValueAsMap(context, requestKey, (Map)requestValue, originalValue, copy);
        }
        if (requestValue instanceof List) {
            return this.processEntryValueAsList(context, requestKey, (List)requestValue, originalValue, copy);
        }
        this.warn(context, requestValue, originalValue, DatasetExtractorMessageCode.DE05, new Object[0]);
        return false;
    }

    private boolean isTransformedClaim(String claimName) {
        if (!this.isTransformedClaimAware()) {
            return false;
        }
        return claimName.startsWith(":");
    }

    private boolean processEntryValueAsMap(DatasetContext context, String requestKey, Map<String, Object> requestValue, Object originalValue, Map<String, Object> copy) {
        ClaimRequirement requirement = ClaimRequirement.parse(requestValue);
        if (requirement != null) {
            if (!this.checkRequirement(requirement, originalValue)) {
                if (context.isConstraintAsFilter()) {
                    this.debug(context, requirement, originalValue, DatasetExtractorMessageCode.DE06, new Object[0]);
                    return false;
                }
                this.trace(context, requirement, originalValue, DatasetExtractorMessageCode.DE07, new Object[0]);
                return true;
            }
            if (!requirement.hasUnreservedKeys()) {
                this.trace(context, requirement, originalValue, DatasetExtractorMessageCode.DE08, new Object[0]);
                copy.put(requestKey, originalValue);
                return true;
            }
        }
        if (originalValue instanceof Map) {
            return this.processEntryValueAsMapWithOriginalAsMap(context, requestKey, requestValue, (Map)originalValue, copy);
        }
        if (originalValue instanceof List) {
            return this.processEntryValueAsMapWithOriginalAsList(context, requestKey, requestValue, (List)originalValue, copy);
        }
        if (requestValue.size() == 0) {
            if (originalValue != null) {
                this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE09, new Object[0]);
                copy.put(requestKey, originalValue);
            } else {
                this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE10, new Object[0]);
            }
            return true;
        }
        this.warn(context, requestValue, originalValue, DatasetExtractorMessageCode.DE11, new Object[0]);
        return false;
    }

    private boolean checkRequirement(ClaimRequirement requirement, Object originalValue) {
        ClaimRequirementChecker checker = new ClaimRequirementChecker(requirement, this.getCurrentTime());
        return checker.check(originalValue);
    }

    private boolean processEntryValueAsMapWithOriginalAsMap(DatasetContext context, String requestKey, Map<String, Object> requestValue, Map<String, Object> originalValue, Map<String, Object> copy) {
        HashMap<String, Object> holder = new HashMap<String, Object>();
        boolean continued = this.processMap(context, requestValue, originalValue, holder);
        if (continued) {
            copy.put(requestKey, holder);
        }
        return continued;
    }

    private boolean processEntryValueAsMapWithOriginalAsList(DatasetContext context, String requestKey, Map<String, Object> requestValue, List<?> originalValue, Map<String, Object> copy) {
        int originalListSize = originalValue.size();
        for (int index = 0; index < originalListSize; ++index) {
            context.getOriginalPointer().append(index);
            Object originalElement = originalValue.get(index);
            if (!(originalElement instanceof Map)) {
                this.warn(context, requestValue, originalElement, DatasetExtractorMessageCode.DE12, new Object[0]);
                context.getOriginalPointer().remove();
                continue;
            }
            HashMap<String, Object> holder = new HashMap<String, Object>();
            boolean continued = this.processMap(context, requestValue, (Map)originalElement, holder);
            if (continued) {
                this.trace(context, requestValue, originalElement, DatasetExtractorMessageCode.DE13, new Object[0]);
                copy.put(requestKey, holder);
            }
            context.getOriginalPointer().remove();
            if (!continued) continue;
            return true;
        }
        this.debug(context, requestValue, originalValue, DatasetExtractorMessageCode.DE14, new Object[0]);
        return false;
    }

    private boolean processEntryValueAsList(DatasetContext context, String requestKey, List<?> requestValue, Object originalValue, Map<String, Object> copy) {
        if (originalValue instanceof Map) {
            return this.processEntryValueAsListWithOriginalAsMap(context, requestKey, requestValue, (Map)originalValue, copy);
        }
        if (originalValue instanceof List) {
            return this.processEntryValueAsListWithOriginalAsList(context, requestKey, requestValue, (List)originalValue, copy);
        }
        this.warn(context, requestValue, originalValue, DatasetExtractorMessageCode.DE15, new Object[0]);
        return false;
    }

    private boolean processEntryValueAsListWithOriginalAsMap(DatasetContext context, String requestKey, List<?> requestValue, Map<String, Object> originalValue, Map<String, Object> copy) {
        int requestListSize = requestValue.size();
        for (int index = 0; index < requestListSize; ++index) {
            Object requestElement = requestValue.get(index);
            if (!(requestElement instanceof Map)) {
                this.warn(context, requestElement, originalValue, DatasetExtractorMessageCode.DE16, new Object[0]);
                continue;
            }
            context.getRequestPointer().append(index);
            Map<String, Object> subCopy = this.extract(context, (Map)requestElement, originalValue);
            if (subCopy != null) {
                this.trace(context, requestElement, originalValue, DatasetExtractorMessageCode.DE17, new Object[0]);
                copy.put(requestKey, Arrays.asList(subCopy));
            }
            context.getRequestPointer().remove();
            if (subCopy == null) continue;
            return true;
        }
        return false;
    }

    private boolean processEntryValueAsListWithOriginalAsList(DatasetContext context, String requestKey, List<?> requestValue, List<?> originalValue, Map<String, Object> copy) {
        int requestListSize = requestValue.size();
        int originalListSize = originalValue.size();
        ArrayList<Map<String, Object>> holder = new ArrayList<Map<String, Object>>(requestValue.size());
        for (int oIndex = 0; oIndex < originalListSize; ++oIndex) {
            Object originalElement = originalValue.get(oIndex);
            if (!(originalElement instanceof Map)) {
                this.warn(context, requestValue, originalElement, DatasetExtractorMessageCode.DE18, new Object[0]);
                continue;
            }
            context.getOriginalPointer().append(oIndex);
            for (int rIndex = 0; rIndex < requestListSize; ++rIndex) {
                Object requestElement = requestValue.get(rIndex);
                if (!(requestElement instanceof Map)) {
                    this.warn(context, requestElement, originalElement, DatasetExtractorMessageCode.DE19, new Object[0]);
                    continue;
                }
                context.getRequestPointer().append(rIndex);
                Map<String, Object> subCopy = this.extract(context, (Map)requestElement, (Map)originalElement);
                if (subCopy != null) {
                    this.trace(context, requestElement, originalElement, DatasetExtractorMessageCode.DE20, new Object[0]);
                    holder.add(subCopy);
                }
                context.getRequestPointer().remove();
                if (subCopy != null) break;
            }
            context.getOriginalPointer().remove();
        }
        if (holder.size() == 0) {
            this.debug(context, requestValue, originalValue, DatasetExtractorMessageCode.DE21, new Object[0]);
            return false;
        }
        this.trace(context, requestValue, originalValue, DatasetExtractorMessageCode.DE22, new Object[0]);
        copy.put(requestKey, holder);
        return true;
    }

    private void warn(DatasetContext context, Object request, Object original, DatasetExtractorMessageCode code, Object ... args) {
        if (this.mLogger != null) {
            this.mLogger.warn(DatasetExtractor.prefix(context, request, original) + code.format(args));
        }
    }

    private void debug(DatasetContext context, Object request, Object original, DatasetExtractorMessageCode code, Object ... args) {
        if (this.mLogger != null) {
            this.mLogger.debug(DatasetExtractor.prefix(context, request, original) + code.format(args));
        }
    }

    private void trace(DatasetContext context, Object request, Object original, DatasetExtractorMessageCode code, Object ... args) {
        if (this.mLogger != null) {
            this.mLogger.trace(DatasetExtractor.prefix(context, request, original) + code.format(args));
        }
    }

    private static String prefix(DatasetContext context, Object request, Object original) {
        return String.format("<request:%s=%s, original:%s=%s> ", context.getRequestPointer(), DatasetExtractor.str(request), context.getOriginalPointer(), DatasetExtractor.str(original));
    }

    private static String str(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Map) {
            return "{object}";
        }
        if (object instanceof List) {
            return "[array]";
        }
        if (object instanceof String) {
            return String.format("\"%s\"", (String)object);
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof ClaimRequirement) {
            return DatasetExtractor.str((ClaimRequirement)object);
        }
        return object.getClass().toString();
    }

    private static String str(ClaimRequirement requirement) {
        Long maxAge;
        List<String> values;
        StringBuilder sb = new StringBuilder("{");
        boolean haveConstraints = false;
        String value = requirement.getValue();
        if (value != null) {
            sb.append("value=\"").append(value).append("\"");
            haveConstraints = true;
        }
        if ((values = requirement.getValues()) != null) {
            if (haveConstraints) {
                sb.append(",");
            }
            sb.append("values=[");
            values.stream().forEach(element -> sb.append("\"").append((String)element).append("\""));
            sb.append("]");
            haveConstraints = true;
        }
        if ((maxAge = requirement.getMaxAge()) != null) {
            if (haveConstraints) {
                sb.append(",");
            }
            sb.append("max_age=").append(maxAge);
        }
        sb.append("}");
        return sb.toString();
    }
}

