/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientAssertionType {
    JWT_BEARER(1, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"),
    JWT_CLIENT_ATTESTATION(2, "urn:ietf:params:oauth:client-assertion-type:jwt-client-attestation");

    private static final ClientAssertionType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ClientAssertionType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientAssertionType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ClientAssertionType parse(String type) {
        if (type == null) {
            return null;
        }
        for (ClientAssertionType entry : sValues) {
            if (!entry.mString.equals(type)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientAssertionType> set) {
        return sHelper.toBits(set);
    }

    public static ClientAssertionType[] toArray(int bits) {
        return (ClientAssertionType[])sHelper.toArray(bits);
    }

    public static EnumSet<ClientAssertionType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ClientAssertionType> toSet(ClientAssertionType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ClientAssertionType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ClientAssertionType> {
        public Helper(ClientAssertionType[] values) {
            super(ClientAssertionType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientAssertionType entry) {
            return entry.getValue();
        }

        protected ClientAssertionType[] newArray(int size) {
            return new ClientAssertionType[size];
        }
    }
}

