/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientAuthMethod {
    NONE(0, "none", 0),
    CLIENT_SECRET_BASIC(1, "client_secret_basic", 1),
    CLIENT_SECRET_POST(2, "client_secret_post", 1),
    CLIENT_SECRET_JWT(3, "client_secret_jwt", 2),
    PRIVATE_KEY_JWT(4, "private_key_jwt", 2),
    TLS_CLIENT_AUTH(5, "tls_client_auth", 4),
    SELF_SIGNED_TLS_CLIENT_AUTH(6, "self_signed_tls_client_auth", 4),
    ATTEST_JWT_CLIENT_AUTH(7, "attest_jwt_client_auth", 2);

    private static final int FLAG_SECRET_BASED = 1;
    private static final int FLAG_JWT_BASED = 2;
    private static final int FLAG_CERTIFICATE_BASED = 4;
    private static final ClientAuthMethod[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;
    private final int mFlags;

    private ClientAuthMethod(short value, String string2, int flags) {
        this.mValue = value;
        this.mString = string2;
        this.mFlags = flags;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientAuthMethod getByValue(short value) {
        if (value < 0 || sValues.length <= value) {
            return null;
        }
        return sValues[value];
    }

    public static ClientAuthMethod parse(String method) {
        if (method == null) {
            return null;
        }
        for (ClientAuthMethod entry : ClientAuthMethod.values()) {
            if (!entry.mString.equals(method)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientAuthMethod> set) {
        return sHelper.toBits(set);
    }

    public static ClientAuthMethod[] toArray(int bits) {
        return (ClientAuthMethod[])sHelper.toArray(bits);
    }

    public static EnumSet<ClientAuthMethod> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ClientAuthMethod> toSet(ClientAuthMethod[] array) {
        return sHelper.toSet(array);
    }

    public boolean isSecretBased() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isJwtBased() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isCertificateBased() {
        return (this.mFlags & 4) != 0;
    }

    static {
        sValues = ClientAuthMethod.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ClientAuthMethod> {
        public Helper(ClientAuthMethod[] values) {
            super(ClientAuthMethod.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientAuthMethod entry) {
            return entry.getValue();
        }

        protected ClientAuthMethod[] newArray(int size) {
            return new ClientAuthMethod[size];
        }
    }
}

