/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientRegistrationType {
    AUTOMATIC(1, "automatic"),
    EXPLICIT(2, "explicit");

    private static final ClientRegistrationType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ClientRegistrationType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientRegistrationType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ClientRegistrationType parse(String clientRegistrationType) {
        if (clientRegistrationType == null) {
            return null;
        }
        for (ClientRegistrationType entry : sValues) {
            if (!entry.mString.equals(clientRegistrationType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientRegistrationType> set) {
        return sHelper.toBits(set);
    }

    public static ClientRegistrationType[] toArray(int bits) {
        return (ClientRegistrationType[])sHelper.toArray(bits);
    }

    public static EnumSet<ClientRegistrationType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ClientRegistrationType> toSet(ClientRegistrationType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ClientRegistrationType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ClientRegistrationType> {
        public Helper(ClientRegistrationType[] values) {
            super(ClientRegistrationType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientRegistrationType entry) {
            return entry.getValue();
        }

        protected ClientRegistrationType[] newArray(int size) {
            return new ClientRegistrationType[size];
        }
    }
}

