/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum EntityType {
    OPENID_RELYING_PARTY(1, "openid_relying_party"),
    OPENID_PROVIDER(2, "openid_provider"),
    OAUTH_AUTHORIZATION_SERVER(3, "oauth_authorization_server"),
    OAUTH_CLIENT(4, "oauth_client"),
    OAUTH_RESOURCE(5, "oauth_resource"),
    FEDERATION_ENTITY(6, "federation_entity"),
    OPENID_CREDENTIAL_ISSUER(7, "openid_credential_issuer");

    private static final EntityType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private EntityType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static EntityType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static EntityType parse(String metadataType) {
        if (metadataType == null) {
            return null;
        }
        for (EntityType entry : sValues) {
            if (!entry.mString.equals(metadataType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<EntityType> set) {
        return sHelper.toBits(set);
    }

    public static EntityType[] toArray(int bits) {
        return (EntityType[])sHelper.toArray(bits);
    }

    public static EnumSet<EntityType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<EntityType> toSet(EntityType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = EntityType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<EntityType> {
        public Helper(EntityType[] values) {
            super(EntityType.class, (Enum[])values);
        }

        @Override
        protected short getValue(EntityType entry) {
            return entry.getValue();
        }

        protected EntityType[] newArray(int size) {
            return new EntityType[size];
        }
    }
}

