/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum FapiMode {
    FAPI1_BASELINE(1, "fapi1_baseline"),
    FAPI1_ADVANCED(2, "fapi1_advanced"),
    FAPI2_SECURITY(3, "fapi2_security"),
    FAPI2_MESSAGE_SIGNING_AUTH_REQ(4, "fapi2_message_signing_auth_req"),
    FAPI2_MESSAGE_SIGNING_AUTH_RES(5, "fapi2_message_signing_auth_res"),
    FAPI2_MESSAGE_SIGNING_INTROSPECTION_RES(6, "fapi2_message_signing_introspection_res");

    private static final FapiMode[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private FapiMode(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public int toBits() {
        return 1 << this.mValue;
    }

    public static FapiMode getByValue(short value) {
        if (value < 0 || sValues.length <= value) {
            return null;
        }
        return sValues[value];
    }

    public static FapiMode parse(String fapiMode) {
        if (fapiMode == null) {
            return null;
        }
        for (FapiMode value : sValues) {
            if (!value.mString.equals(fapiMode)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<FapiMode> set) {
        return sHelper.toBits(set);
    }

    public static FapiMode[] toArray(int bits) {
        return (FapiMode[])sHelper.toArray(bits);
    }

    public static EnumSet<FapiMode> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<FapiMode> toSet(FapiMode[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = FapiMode.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<FapiMode> {
        public Helper(FapiMode[] values) {
            super(FapiMode.class, (Enum[])values);
        }

        @Override
        protected short getValue(FapiMode entry) {
            return entry.getValue();
        }

        protected FapiMode[] newArray(int size) {
            return new FapiMode[size];
        }
    }
}

