/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class IdTokenClaims {
    public static final String ISS = "iss";
    public static final String SUB = "sub";
    public static final String AUD = "aud";
    public static final String EXP = "exp";
    public static final String IAT = "iat";
    public static final String AUTH_TIME = "auth_time";
    public static final String NONCE = "nonce";
    public static final String ACR = "acr";
    public static final String AMR = "amr";
    public static final String AZP = "azp";
    private static final SortedSet<String> sIdTokenClaims;

    private IdTokenClaims() {
    }

    public static boolean isIdTokenClaim(String claimName) {
        if (claimName == null) {
            return false;
        }
        return sIdTokenClaims.contains(claimName);
    }

    public static SortedSet<String> getIdTokenClaims() {
        return sIdTokenClaims;
    }

    static {
        TreeSet<String> set = new TreeSet<String>();
        set.add(ISS);
        set.add(SUB);
        set.add(AUD);
        set.add(EXP);
        set.add(IAT);
        set.add(AUTH_TIME);
        set.add(NONCE);
        set.add(ACR);
        set.add(AMR);
        set.add(AZP);
        sIdTokenClaims = Collections.unmodifiableSortedSet(set);
    }
}

