/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum TokenType {
    JWT(1, "urn:ietf:params:oauth:token-type:jwt"),
    ACCESS_TOKEN(2, "urn:ietf:params:oauth:token-type:access_token"),
    REFRESH_TOKEN(3, "urn:ietf:params:oauth:token-type:refresh_token"),
    ID_TOKEN(4, "urn:ietf:params:oauth:token-type:id_token"),
    SAML1(5, "urn:ietf:params:oauth:token-type:saml1"),
    SAML2(6, "urn:ietf:params:oauth:token-type:saml2");

    private static final TokenType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private TokenType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static TokenType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static TokenType parse(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        for (TokenType entry : sValues) {
            if (!entry.mString.equals(tokenType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<TokenType> set) {
        return sHelper.toBits(set);
    }

    public static TokenType[] toArray(int bits) {
        return (TokenType[])sHelper.toArray(bits);
    }

    public static EnumSet<TokenType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<TokenType> toSet(TokenType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = TokenType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<TokenType> {
        public Helper(TokenType[] values) {
            super(TokenType.class, (Enum[])values);
        }

        @Override
        protected short getValue(TokenType entry) {
            return entry.getValue();
        }

        protected TokenType[] newArray(int size) {
            return new TokenType[size];
        }
    }
}

